#include "LocomotionEvent.h"
#include <sstream>

std::string
LocomotionEvent::getDescription(bool showTypeSpecific/*=true*/, unsigned int verbosity/*=0*/) const {
	if(!showTypeSpecific)
		return EventBase::getDescription(showTypeSpecific,verbosity);
	std::ostringstream logdata;
	logdata << EventBase::getDescription(showTypeSpecific,verbosity) << '\t' << x << '\t' << y << '\t' << a;
	return logdata.str();
}
	
unsigned int
LocomotionEvent::getBinSize() const {
	unsigned int used=EventBase::getBinSize();
	used+=creatorSize("EventBase::LocomotionEvent");
	used+=sizeof(x);
	used+=sizeof(y);
	used+=sizeof(a);
	return used;
}

unsigned int
LocomotionEvent::LoadBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=EventBase::LoadBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=checkCreator("EventBase::LocomotionEvent",buf,len,true))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(x,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(y,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(a,buf,len))) return 0;
	len-=used; buf+=used;
	return origlen-len;	
}

unsigned int
LocomotionEvent::SaveBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=EventBase::SaveBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=saveCreator("EventBase::LocomotionEvent",buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(x,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(y,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(a,buf,len))) return 0;
	len-=used; buf+=used;
	return origlen-len;
}


/*! @file
 * @brief Implements LocomotionEvent, which gives updates regarding the current movement of the robot through the world
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2004/09/01 21:30:57 $
 */
