//-*-c++-*-
#ifndef INCLUDED_DataEvent_h_
#define INCLUDED_DataEvent_h_

#include "Events/EventBase.h"

//! for passing around data (or pointers to data)
template<class T>
class DataEvent : public EventBase {
public:
	//!@name Constructors
	//!
	DataEvent() : EventBase() {}
	DataEvent(const T& d, EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur=0) : EventBase(gid,sid,tid,dur), data(d) {}
	DataEvent(const T& d, EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur, const std::string& n, float mag) : EventBase(gid,sid,tid,dur,n,mag), data(d) {}
	//@}

	void setData(const T& d) { data=d; } //!< assigns @a d to the internal #data
	const T& getData() const { return data; } //!< returns #data
	T& getData() { return data; } //!< returns #data

protected:
	T data; //!< the data being communicated

private:
	DataEvent(const DataEvent& fbk); //!< don't call
	const DataEvent& operator=(const DataEvent& fbk); //!< don't call
};

/*! @file
 * @brief Defines DataEvent, for passing around data (or pointers to data)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2004/01/18 10:16:57 $
 */

#endif
