//-*-c++-*-
#ifndef INCLUDED_TimeOutTrans_h_
#define INCLUDED_TimeOutTrans_h_

#include "Behaviors/Transition.h"
#include "Events/EventRouter.h"

//! causes a transition after a specified amount of time has passed
class TimeOutTrans : public Transition {
public:
  //! constructor, specify delay in milliseconds
  TimeOutTrans(StateNode* destination, unsigned int delay) : Transition(destination), d(delay) {}

  //!starts timer
  virtual void DoStart() {
    Transition::DoStart();
    resetTimer(); 
  }

  //!stops timer
  virtual void DoStop() { erouter->removeListener(this); Transition::DoStop(); }
  
  //!resets timer
  void resetTimer() {
    // std::cout << "Reset @ " << get_time() << " stop @ " << get_time()+d << ' ' << this << std::endl;
    erouter->addTimer(this,0,d,false);
  }

  //!if we receive the timer event, fire()
  virtual void processEvent(const EventBase&) {
    // std::cout << "Timeout @ " << get_time() << " from " << event.getName() << ' ' << this << std::endl;
    fire();
  }

  virtual std::string getName() const { return "TimeOutTrans"; }

protected:
  //!amount to delay (in milliseconds) before transition
  unsigned int d;
};

/*! @file
 * @brief Defines TimeOutTrans, which causes a transition after a specified amount of time has passed
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.12 $
 * $State: Exp $
 * $Date: 2004/10/07 19:07:05 $
 */

#endif
