//-*-c++-*-
#ifndef INCLUDED_EventTrans_h_
#define INCLUDED_EventTrans_h_

#include "Behaviors/Transition.h"
#include "Events/EventRouter.h"

//! causes a transition when the specified event is received

class EventTrans : public Transition {
private:
  int argcount;
  EventBase::EventGeneratorID_t egid;
  unsigned int esid;
  EventBase::EventTypeID_t etid;

public:
  EventTrans(StateNode* destination, EventBase::EventGeneratorID_t gid) :
    Transition(destination), argcount(1), egid(gid), esid(0), etid(EventBase::statusETID) {};

  EventTrans(StateNode* destination, EventBase::EventGeneratorID_t gid, unsigned int sid) :
    Transition(destination), argcount(2), egid(gid), esid(sid), etid(EventBase::statusETID) {};

  EventTrans(StateNode* destination, EventBase::EventGeneratorID_t gid, 
	     unsigned int sid, EventBase::EventTypeID_t tid) :
    Transition(destination), argcount(3), egid(gid), esid(sid), etid(tid) {};

  //! starts listening
  virtual void DoStart() {
    Transition::DoStart();
    switch (argcount) {
    case 1: erouter->addListener(this,egid); break;
    case 2: erouter->addListener(this,egid,esid); break;
    case 3: erouter->addListener(this,egid,esid,etid);
    };
  }

  //! stops listening
  virtual void DoStop() {
    erouter->removeListener(this);
    Transition::DoStop();
  }

  //! fire the transition if an event is seen
  virtual void processEvent(const EventBase&) { fire(); }

  virtual std::string getName() const { return "EventTrans"; }

};

/*! @file
 * @brief Defines EventTrans, which causes a transition if an event of the specified type occurs
 * @author dst (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2004/10/07 19:07:05 $
 */

#endif
