//-*-c++-*-
#ifndef INCLUDED_CompletionTrans_h_
#define INCLUDED_CompletionTrans_h_

#include "Behaviors/StateNode.h"
#include "Behaviors/Transition.h"
#include "Events/EventRouter.h"

//! causes a transition when at least @e n sources have signalled completion;  @e n = 0 means "all" (default)
class CompletionTrans : public Transition {
protected:
  int minsrcs;
  bool *completions;  //!< pointer to array for recording completion events for all sources

public:
  CompletionTrans(StateNode* destination, int n=0) :
    Transition(destination), minsrcs(n), completions(NULL) {};

  //! starts listening
  virtual void DoStart() {
    Transition::DoStart();
    unsigned int const numsrcs = getSources().size();
    completions = new bool[numsrcs];
    for (unsigned int i = 0; i < numsrcs; i++) {
      completions[i] = false;
      erouter->addListener(this,
			   EventBase::stateMachineEGID,
			   (unsigned int)getSources()[i],
			   EventBase::statusETID);
    };
  }

  //! stops listening
  virtual void DoStop() {
    erouter->removeListener(this);
    delete completions;
    completions = NULL;
    Transition::DoStop();
  }

  //! record completions, and fire the transition if all sources have completed
  virtual void processEvent(const EventBase &event) {
    int numcomplete = 0;
    for ( unsigned int i=0; i<getSources().size(); i++ ) {
      if ( event.getSourceID() == (unsigned int)getSources()[i] )
	completions[i] = true;
      if ( completions[i] ) ++numcomplete;
    };
    int const threshold = (minsrcs > 0 ? minsrcs : (int)getSources().size());
    if (numcomplete >= threshold) fire();
  }

  virtual std::string getName() const { return "CompletionTrans"; }

protected:
  //!@name Dummy functions to satisfy the compiler
  CompletionTrans(const CompletionTrans&);  //!< don't call this
  CompletionTrans& operator=(const CompletionTrans&);  //!< don't call this
  //@}

};

/*! @file
 * @brief Defines Completiontrans, which causes a transition if all sources have signalled completion
 * @author dst (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2004/10/17 01:16:10 $
 */

#endif
