#include "Transition.h"
#include "StateNode.h"
#include "Wireless/Wireless.h"
#include "SoundPlay/SoundManager.h"

void Transition::fire() {
	//serr->printf("%s fire() - enter %d\n",getName().c_str(),get_time());

	AddReference(); //just in case a side effect of this transition is to dereference the transition, we don't want to be deleted while still transitioning

	if(sound.size()!=0)
		sndman->PlayFile(sound);

	for(unsigned int i=0; i<srcs.size(); i++)
		if(srcs[i]->isActive()) //It's usually a bad idea to call DoStop/DoStart when it's already stopped/started...
			srcs[i]->DoStop();
	for(unsigned int i=0; i<dsts.size(); i++)
		if(!dsts[i]->isActive())
			dsts[i]->DoStart();

	//serr->printf("%s fire() - leave %d\n",getName().c_str(),get_time());
	RemoveReference();
}

/*! @file
 * @brief Implements Transition, represents a transition between StateNodes.
 * @author ejt (Creator)
 *
 * $Author: dst $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.8 $
 * $State: Exp $
 * $Date: 2004/10/08 00:08:34 $
 */

