#include "StateNode.h"
#include "Events/EventRouter.h"
#include "Wireless/Wireless.h"

StateNode::~StateNode() {
	ASSERT(!isActive(), "Destructing while active?")
	for(std::vector<Transition*>::iterator it=transitions.begin(); it!=transitions.end(); it++)
		(*it)->RemoveReference();
	if(issetup) {
		for(std::vector<StateNode*>::iterator it=nodes.begin(); it!=nodes.end(); it++)
			(*it)->RemoveReference();
	}
}

void StateNode::addTransition(Transition* trans) {
	transitions.push_back(trans);
	trans->AddReference();
	trans->addSource(this);
}

StateNode* StateNode::addNode(StateNode* node) {
  nodes.push_back(node);
  node->AddReference();
  if ( node->parent == NULL )
    node->parent = this;
  return node;
}

void StateNode::DoStart() {
	BehaviorBase::DoStart();
	if(!issetup) {
		setup();
		issetup=true;
	}
	for(std::vector<Transition*>::iterator it=transitions.begin(); it!=transitions.end(); it++)
	  if ( !(*it)->isActive()  ) (*it)->DoStart();
	erouter->postEvent(EventBase::stateMachineEGID,reinterpret_cast<unsigned int>(this),EventBase::activateETID,0,getName(),1);
	if(parent!=NULL)
		parent->transitionTo(this);
}

void StateNode::DoStop() {
	for(std::vector<Transition*>::iterator it=transitions.begin(); it!=transitions.end(); it++) {
		if((*it)->isActive())
			(*it)->DoStop();
	}
	for(std::vector<StateNode*>::iterator it=nodes.begin(); it!=nodes.end(); it++)
		if((*it)->isActive())
			(*it)->DoStop();
	if(!retain) {
		teardown();
		issetup=false;
		for(std::vector<StateNode*>::iterator it=nodes.begin(); it!=nodes.end(); it++)
			(*it)->RemoveReference();
		nodes.clear();
	}
	erouter->postEvent(EventBase::stateMachineEGID,reinterpret_cast<unsigned int>(this),EventBase::deactivateETID,0,getName(),0);
	BehaviorBase::DoStop();
}

void StateNode::setName(const std::string& n) {
	name=n;
}

void StateNode::transitionTo(StateNode*) {
	// may want to throw a status event here
}

void StateNode::transitionFrom(StateNode*) {
	// may want to throw a status event here
}

/*! @file 
 * @brief Describes StateNode, which is both a state machine controller as well as a node within a state machine itself
 * @author ejt (Creator)
 *
 * $Author: dst $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.17 $
 * $State: Exp $
 * $Date: 2004/10/04 22:57:56 $
 */

