//-*-c++-*-
#ifndef INCLUDED_SoundNode_h_
#define INCLUDED_SoundNode_h_

#include "Behaviors/StateNode.h"
#include "Events/EventRouter.h"
#include "SoundPlay/SoundManager.h"

//! A simple StateNode that plays a sound upon startup and throws a status event on completion
class SoundNode : public StateNode {
protected:
  std::string filename;
  SoundManager::Play_ID curplay_id;

public:
  //! constructor
  SoundNode(std::string nodename="SoundNode", std::string soundfilename="") : 
    StateNode(nodename), filename(soundfilename), curplay_id(SoundManager::invalid_Play_ID) {}

  //! activate the node
  virtual void DoStart() {
    curplay_id = sndman->PlayFile(filename);
    erouter->addListener(this,EventBase::audioEGID,curplay_id,EventBase::deactivateETID);
    StateNode::DoStart();  // don't activate transitions until our listener has been added
  }

  //! deactivate the node
  virtual void DoStop() {
    erouter->removeListener(this);
    StateNode::DoStop();
  }

  //! receive audioEGID status event and throw stateMachineEGID status event
  virtual void processEvent(const EventBase&) {
    erouter->postEvent(EventBase::stateMachineEGID,(unsigned int)this,EventBase::statusETID,0);
  }

  //! interrupts playing of the current sound
  void StopPlay() {
    sndman->StopPlay(curplay_id);
    curplay_id = SoundManager::invalid_Play_ID;
  }

  //! returns the name of the sound file associated with this node
  std::string getFileName() { return filename; }

  //! sets the name of the sound file associated with this node
  void setFileName(std::string &soundfilename) { filename = soundfilename; }

};

/*! @file
 * @brief Defines SoundNode, a simple StateNode that plays a sound and throws a status event upon completion
 * @author dst (Creator)
 *
 * $Author: dst $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2004/10/08 00:08:47 $
 */

#endif
