#include "WalkToTargetMachine.h"
#include "Motion/HeadPointerMC.h"
#include "Motion/WalkMC.h"
#include "Events/VisionObjectEvent.h"
#include "Shared/WorldState.h"

//! Converts degrees to radians
inline double DtoR(double deg) { return (deg/180.0*M_PI); }

void WalkToTargetMachine::setup() {
	StateNode::setup();
	if(close!=NULL)
		addTransition(closeTrans=new VisualTargetCloseTrans(close,tracking));
	if(lost!=NULL)
		addTransition(timeout=new TimeOutTrans(lost,500));
}


void WalkToTargetMachine::DoStart() {
	StateNode::DoStart();

	headpointer_id = motman->addPersistentMotion(SharedObject<HeadPointerMC>());
	walker_id = motman->addPersistentMotion(SharedObject<WalkMC>());

	erouter->addListener(this,EventBase::visObjEGID,tracking);
}

void WalkToTargetMachine::DoStop() {
	erouter->removeListener(this);

	motman->removeMotion(headpointer_id);
	headpointer_id=MotionManager::invalid_MC_ID;
	motman->removeMotion(walker_id);
	walker_id=MotionManager::invalid_MC_ID;

	StateNode::DoStop();
}

void WalkToTargetMachine::teardown() {
	closeTrans=NULL;
	timeout=NULL;
}

//this could be cleaned up event-wise (only use a timer when out of view)
void WalkToTargetMachine::processEvent(const EventBase& event) {
	if(timeout)
		timeout->resetTimer();
	static float horiz=0,vert=0;
	const VisionObjectEvent *ve = dynamic_cast<const VisionObjectEvent*>(&event);
	if(ve!=NULL && event.getTypeID()==EventBase::statusETID) {
		horiz=ve->getCenterX();
		vert=ve->getCenterY();
	} else
		return;

	//cout << "Pos: " << horiz << ' ' << vert << endl;

	double tilt=state->outputs[HeadOffset+TiltOffset]-vert*M_PI/6;
	double pan=state->outputs[HeadOffset+PanOffset]-horiz*M_PI/7.5;
	if(tilt>outputRanges[HeadOffset+TiltOffset][MaxRange])
		tilt=outputRanges[HeadOffset+TiltOffset][MaxRange];
	if(tilt<outputRanges[HeadOffset+TiltOffset][MinRange]*3/4)
		tilt=outputRanges[HeadOffset+TiltOffset][MinRange]*3/4;
	if(pan>outputRanges[HeadOffset+PanOffset][MaxRange]*2/3)
		pan=outputRanges[HeadOffset+PanOffset][MaxRange]*2/3;
	if(pan<outputRanges[HeadOffset+PanOffset][MinRange]*2/3)
		pan=outputRanges[HeadOffset+PanOffset][MinRange]*2/3;
	HeadPointerMC * headpointer= (HeadPointerMC*)motman->checkoutMotion(headpointer_id);
	headpointer->setJoints(tilt,pan,0);
	motman->checkinMotion(headpointer_id);

	WalkMC * walker = (WalkMC*)motman->checkoutMotion(walker_id);
	if(pan<-.05 || pan>.05)
		walker->setTargetVelocity(100,0,pan);
	else
		walker->setTargetVelocity(160,0,0);
	motman->checkinMotion(walker_id);
}

/*! @file
 * @brief Implements WalkToTargetMachine, a state machine for walking towards a visual target
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.14 $
 * $State: Exp $
 * $Date: 2004/10/17 01:16:10 $
 */

