//-*-c++-*-
#ifndef INCLUDED_StareAtPawBehavior2_h_
#define INCLUDED_StareAtPawBehavior2_h_

#include "Behaviors/BehaviorBase.h"
#include "Motion/PIDMC.h"
#include "Motion/HeadPointerMC.h"
#include "Motion/PostureMC.h"
#include "Motion/MotionManager.h"
#include "Shared/SharedObject.h"
#include "Motion/roboop/robot.h"
#include "Shared/Config.h"
#include "Motion/Kinematics.h"


//! Uses kinematics to track the paw which last received a button press with the camera
class StareAtPawBehavior2 : public BehaviorBase {
public:
	//! constructor
	StareAtPawBehavior2()
		: BehaviorBase(), lastLeg(LFrLegOrder), pointID(MotionManager::invalid_MC_ID)
	{ }

	virtual void DoStart() {
		BehaviorBase::DoStart(); // do this first
		pointID=motman->addPersistentMotion(SharedObject<HeadPointerMC>());
		erouter->addListener(this,EventBase::sensorEGID);
		erouter->addListener(this,EventBase::buttonEGID);
		if(state->robotDesign == WorldState::ERS7Mask)
			cout << "NOTICE: The ERS-7 has a rather \"sticky\" nod joint\n"
					 << "(the upper tilt joint).  This can cause it to hesitate\n"
					 << "or altogether fail to precisely center the target position\n"
					 << "vertically in the center of the image...\n" << endl;
	}

	virtual void DoStop() {
		motman->removeMotion(pointID);
		pointID=MotionManager::invalid_MC_ID;
		erouter->removeListener(this);
		BehaviorBase::DoStop(); // do this last
	}

	virtual void processEvent(const EventBase& e) {
		if(e.getGeneratorID()==EventBase::buttonEGID) {

			if(e.getSourceID()==LFrPawOffset) {
				lastLeg=LFrLegOrder;
			} else if(e.getSourceID()==RFrPawOffset) {
				lastLeg=RFrLegOrder;
			} else
				return;
			if(e.getTypeID()==EventBase::activateETID) {
				unsigned int lastlegoff=LegOffset+lastLeg*JointsPerLeg;
				SharedObject<PIDMC> relaxLeg(lastlegoff,lastlegoff+JointsPerLeg,0);
				motman->addPrunableMotion(relaxLeg);
			} else if(e.getTypeID()==EventBase::deactivateETID) {
				unsigned int lastlegoff=LegOffset+lastLeg*JointsPerLeg;
				SharedObject<PIDMC> tightLeg(lastlegoff,lastlegoff+JointsPerLeg,1);
				motman->addPrunableMotion(tightLeg);
			}

		} else if(e.getGeneratorID()==EventBase::sensorEGID) {

			//Find paw location
			const char * ipname=(lastLeg==LFrLegOrder?"ToeLFrPaw":"ToeRFrPaw");
			NEWMAT::ColumnVector Pobj=kine->getFrameInterestPoint(BaseFrameOffset,ipname);

			//Compute neck angles
			PostureEngine pose;
			NEWMAT::ColumnVector Plink(4); Plink=0; Plink(3)=1; //infinite ray along z axis, maximizes distance from camera to objective
			//NEWMAT::ColumnVector Plink(4); Plink=0; Plink(3)=80; Plink(4)=1; //keep head 8cm away from paw
			//Alternatively, could also use the pack function a la: Plink=Kinematics::pack(0,0,80);
			pose.solveLinkVector(Pobj,CameraFrameOffset,Plink);
			
			//Set joint values
			MMAccessor<HeadPointerMC>(pointID)->setJoints(pose(HeadOffset+0).value,pose(HeadOffset+1).value,pose(HeadOffset+2).value);
		} else {
			serr->printf("StareAtPawBehavior2: Unhandled event %s\n",e.getName().c_str());
		}
	}

	virtual std::string getName() const { return "StareAtPawBehavior2"; }

	static std::string getClassDescription() { return "Uses kinematics to track the paw which last received a button press with the camera"; }
	
protected:
	LegOrder_t lastLeg;
	MotionManager::MC_ID pointID;
};

/*! @file
 * @brief Defines StareAtPawBehavior2, which uses kinematics to track the paw which last received a button press with the camera
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.12 $
 * $State: Exp $
 * $Date: 2004/10/17 01:32:24 $
 */

#endif
