//-*-c++-*-
#ifndef INCLUDED_StareAtPawBehavior_h_
#define INCLUDED_StareAtPawBehavior_h_

#include "Behaviors/BehaviorBase.h"
#include "Motion/OldKinematics.h"
#include "Motion/PIDMC.h"
#include "Motion/HeadPointerMC.h"
#include "Motion/MotionManager.h"
#include "Shared/SharedObject.h"


//! Uses kinematics to track the paw which last received a button press with the camera
class StareAtPawBehavior : public BehaviorBase {
public:
	//! constructor
	StareAtPawBehavior()
		: BehaviorBase(), lastLeg(LFrLegOrder), pointID(MotionManager::invalid_MC_ID)
	{ }

	virtual void DoStart() {
		BehaviorBase::DoStart(); // do this first
		for(unsigned int i=0; i<NumHeadJoints; i++)
			head_angles[i]=state->outputs[HeadOffset+i];
		pointID=motman->addPersistentMotion(SharedObject<HeadPointerMC>());
		erouter->addListener(this,EventBase::sensorEGID);
		erouter->addListener(this,EventBase::buttonEGID);
	}

	virtual void DoStop() {
		motman->removeMotion(pointID);
		pointID=MotionManager::invalid_MC_ID;
		erouter->removeListener(this);
		BehaviorBase::DoStop(); // do this last
	}

	virtual void processEvent(const EventBase& e) {
		if(e.getGeneratorID()==EventBase::buttonEGID) {

			if(e.getSourceID()==LFrPawOffset)
				lastLeg=LFrLegOrder;
			else if(e.getSourceID()==RFrPawOffset)
				lastLeg=RFrLegOrder;
			else
				return;
			if(e.getTypeID()==EventBase::activateETID) {
				unsigned int lastlegoff=LegOffset+lastLeg*JointsPerLeg;
				SharedObject<PIDMC> relaxLeg(lastlegoff,lastlegoff+JointsPerLeg,0);
				motman->addPrunableMotion(relaxLeg);
			} else if(e.getTypeID()==EventBase::deactivateETID) {
				unsigned int lastlegoff=LegOffset+lastLeg*JointsPerLeg;
				SharedObject<PIDMC> tightLeg(lastlegoff,lastlegoff+JointsPerLeg,1);
				motman->addPrunableMotion(tightLeg);
			}

		} else if(e.getGeneratorID()==EventBase::sensorEGID) {

			double leg_angles[JointsPerLeg];
			for(unsigned int i=0; i<JointsPerLeg; i++)
				leg_angles[i]=state->outputs[LegOffset+lastLeg*JointsPerLeg+i];
			vector3d paw;
			GetLegPosition(paw,leg_angles,lastLeg);
			paw-=body_to_neck; //target should be neck-relative
			paw.z+=body_to_neck.z; // but body-height relative (#@%&$)
			GetHeadAngles(head_angles,paw,0,0);
			/*{
				double tmp[JointsPerLeg];
				GetLegAngles(tmp,paw,lastLeg);
				sout->printf("Leg: (%g,%g,%g) (%g,%g,%g) (%g,%g,%g)\n",leg_angles[0],leg_angles[1],leg_angles[2],paw.x,paw.y,paw.z,tmp[0],tmp[1],tmp[2]);
				vector3d tmp2;
				tmp2=RunForwardModel(head_angles,0,0,vector3d(0,0,0));
				sout->printf("Head: (%g,%g,%g) (%g,%g,%g) (%g,%g,%g)\n",tmp2.x,tmp2.y,tmp2.z,head_angles[0],head_angles[1],head_angles[2],state->outputs[HeadOffset+0],state->outputs[HeadOffset+1],state->outputs[HeadOffset+2]);
				}*/
			MMAccessor<HeadPointerMC>(pointID)->setJoints(head_angles[0],head_angles[1],head_angles[2]);
			
		} else {
			serr->printf("StareAtPawBehavior: Unhandled event %s\n",e.getName().c_str());
		}
	}

	virtual std::string getName() const { return "StareAtPawBehavior"; }

	static std::string getClassDescription() { return "Uses kinematics to track the paw which last received a button press with the camera"; }
	
protected:
	LegOrder_t lastLeg;
	MotionManager::MC_ID pointID;
	double head_angles[JointsPerLeg];
};

/*! @file
 * @brief Defines StareAtPawBehavior, which uses kinematics to track the paw which last received a button press with the camera
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2004/10/17 01:16:10 $
 */

#endif
