#include "PaceTargetsMachine.h"
#include "Behaviors/Transition.h"
#include "WalkToTargetMachine.h"
#include "Behaviors/Nodes/WalkNode.h"
#include "ExploreMachine.h"
#include "Behaviors/Transitions/TimeOutTrans.h"
#include "Behaviors/Transitions/VisualTargetTrans.h"
#include "Behaviors/Nodes/OutputNode.h"
#include "Behaviors/Nodes/PlayMotionSequenceNode.h"
#include "Behaviors/Nodes/GroupNode.h"
#include "SoundPlay/SoundManager.h"

void PaceTargetsMachine::setup() {
	StateNode::setup();

	WalkNode * turnAround = new WalkNode(0,0,1,this);
	turnAround->setName(getName()+"::TurnAround");
	addNode(turnAround);

	GroupNode * explGrp = new GroupNode(getName()+"::ExplGroup",this);
	addNode(explGrp);
	{
		ExploreMachine * explore = new ExploreMachine(explGrp->getName()+"::Explore",explGrp);
		explGrp->addNode(explore);
		PlayMotionSequenceNode<MotionSequence::SizeSmall> * panhead = new PlayMotionSequenceNode<MotionSequence::SizeSmall>(explGrp->getName()+"::PanHead",explGrp,"/ms/data/motion/pan_head.mot",true);
		explGrp->addNode(panhead);
	}

	WalkToTargetMachine * chase = new WalkToTargetMachine(ProjectInterface::visPinkBallSID,turnAround,explGrp,this);
	chase->setName(getName()+"::Chase");
	addNode(chase);

	//starts out exploring
	start=explGrp;

	Transition * tmptrans=NULL;

	//if it sees pink, chase it
	explGrp->addTransition(tmptrans=new VisualTargetTrans(chase,ProjectInterface::visPinkBallSID));
	tmptrans->setSound("cutey.wav");

	//once you've turned around, explore
	turnAround->addTransition(tmptrans=new TimeOutTrans(explGrp,3500));
	tmptrans->setSound("barkmed.wav");

	//add some more sounds
	//!@todo extract these transitions from within chase - i don't like this way of doing things anymore...
	chase->setup();
	chase->getLostTrans()->setSound("whimper.wav");
	chase->getCloseTrans()->setSound("fart.wav");

	//preload the sounds so we don't pause on tranisitions
	sndman->LoadFile("cutey.wav");
	sndman->LoadFile("barkmed.wav");
	sndman->LoadFile("whimper.wav");
	sndman->LoadFile("fart.wav");
}

void PaceTargetsMachine::DoStart() {
	StateNode::DoStart();
	start->DoStart();
}

void PaceTargetsMachine::teardown() {
	//preload the sounds
	sndman->ReleaseFile("cutey.wav");
	sndman->ReleaseFile("barkmed.wav");
	sndman->ReleaseFile("whimper.wav");
	sndman->ReleaseFile("fart.wav");
}

/*! @file
 * @brief Implements PaceTargetsMachine, a StateMachine for walking back and forth between two visual targets
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.11 $
 * $State: Exp $
 * $Date: 2003/12/08 00:20:57 $
 */

