//-*-c++-*-

#ifndef INCLUDED_GroundPlaneBehavior_h_
#define INCLUDED_GroundPlaneBehavior_h_

#include "Behaviors/BehaviorBase.h"
#include "Motion/Kinematics.h"
#include "Motion/PIDMC.h"
#include "Motion/MotionManager.h"
#include "Shared/ERS7Info.h"
#include "Shared/ERS2xxInfo.h"
#include "Shared/WorldState.h"

//! Reports the location of the center of the camera image on the ground plane
class GroundPlaneBehavior : public BehaviorBase {
public:
	//! constructor
	GroundPlaneBehavior()
		: BehaviorBase(),
			head_release(EventBase::buttonEGID,(state->robotDesign&WorldState::ERS7Mask)?(int)ERS7Info::HeadButOffset:(int)ERS2xxInfo::HeadFrButOffset,EventBase::activateETID,0),
			head_lock(EventBase::buttonEGID,(state->robotDesign&WorldState::ERS7Mask)?(int)ERS7Info::HeadButOffset:(int)ERS2xxInfo::HeadFrButOffset,EventBase::deactivateETID,0),
			clock(EventBase::timerEGID,0,EventBase::statusETID,250)
	{ }

	virtual void DoStart() {
		BehaviorBase::DoStart(); // do this first
		erouter->addListener(this,head_release);
		erouter->addListener(this,head_lock);
		processEvent(clock);
	}

	virtual void DoStop() {
		erouter->removeListener(this);
		BehaviorBase::DoStop(); // do this last
	}

	virtual void processEvent(const EventBase& e) {
		if(e==clock) {
			//This is the direction gravity is pulling - probably a good way to find out
			//the attitude of the robot, assuming it is not moving.
			//** Note that the LAccel sensor needs to be negated to match the coordinate system **//
			NEWMAT::ColumnVector down=Kinematics::pack(state->sensors[BAccelOffset],
			                                           -state->sensors[LAccelOffset],
			                                           state->sensors[DAccelOffset]);
			
			//Just for kicks, lets report which leg is off the ground
			cout << "I think leg " << kine->findUnusedLeg(down) << " is least used" << endl;

			//First we determine the ground plane
			NEWMAT::ColumnVector p=kine->calculateGroundPlane(down);
			cout << "Ground plane: " << p(1)<<"x + " << p(2)<<"y + " << p(3)<<"z = 1" << endl;

			//Project to ground plane - we do it twice here, once for camera frame and once for base frame
			NEWMAT::ColumnVector ray(4); ray(1)=ray(2)=0; ray(3)=ray(4)=1;
			NEWMAT::ColumnVector hit;
			//cout <<"Current head:\n"<<state->outputs[HeadOffset] <<' '<< state->outputs[HeadOffset+1] <<' '<< state->outputs[HeadOffset+2] << endl <<kine->getTransform(CameraFrameOffset);
			hit=kine->projectToPlane(CameraFrameOffset,ray,BaseFrameOffset,p,CameraFrameOffset);
			cout << "Intersection_camera: (" << hit(1)<<','<<hit(2)<<','<<hit(3)<<')'<<endl;
			hit=kine->projectToPlane(CameraFrameOffset,ray,BaseFrameOffset,p,BaseFrameOffset);
			cout << "Intersection_base: (" << hit(1)<<','<<hit(2)<<','<<hit(3)<<')'<<endl;

		} else if(e==head_release) {
			motman->addPrunableMotion(SharedObject<PIDMC>(HeadOffset,HeadOffset+NumHeadJoints,0));
			erouter->addListener(this,clock);
			processEvent(clock);
		} else if(e==head_lock) {
			motman->addPrunableMotion(SharedObject<PIDMC>(HeadOffset,HeadOffset+NumHeadJoints,1));
			erouter->removeListener(this,clock);
		} else {
			ASSERT(false,"unprocessed event " << e.getName() << endl);
		}
	}

	virtual std::string getName() const { return "GroundPlaneBehavior"; }

	static std::string getClassDescription() { return "Reports the location of the center of the camera image on the ground plane"; }
	
protected:
	EventBase head_release, head_lock, clock;
};

/*! @file
 * @brief Defines GroundPlaneBehavior, which reports the location of the center of the camera image on the ground plane
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2004/10/17 01:16:10 $
 */

#endif
