//-*-c++-*-
#ifndef INCLUDED_CrashTestBehavior_h_
#define INCLUDED_CrashTestBehavior_h_

#include "Behaviors/BehaviorBase.h"
#include "Wireless/Wireless.h"

//! Demonstrates (lack of) blocking using serr to (not) pinpoint a crash
class CrashTestBehavior : public BehaviorBase {
public:
	CrashTestBehavior() : BehaviorBase()	{}
	
	virtual void DoStart() {
		//call superclass first for housekeeping:
		BehaviorBase::DoStart();

		//now do your code:
		for(unsigned int i=0; i<100; i++) {
			serr->printf("Hello serr!  This is %d\n",i);
			if(i==33)
				*(int*)0xDEADDEAD=0x600DB4E;
		}
		//Hate to break it to you, but we're never going to get here...
	}
	
	virtual std::string getName() const {
		// Name is used for menus, or debugging.
		return "CrashTestBehavior";
	}
	
	static std::string getClassDescription() {
		// This string will be shown by the HelpControl or by the tooltips of the Controller GUI
		return "A little demo of blocking output before a crash after output #33 (yes, this crashes the AIBO)";
	}
	
};

/*! @file
 * @brief Defines CrashTestBehavior, demonstrates (lack of) blocking using serr to (not) pinpoint a crash
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2004/08/25 01:07:45 $
 */

#endif
