//-*-c++-*-

// This is an empty Behavior template file.
// Replace ASCIIVisionBehavior and streams low-resolution ASCII-art of the camera image to sout as appropriate, and go to town!

#ifndef INCLUDED_ASCIIVisionBehavior_h_
#define INCLUDED_ASCIIVisionBehavior_h_

#include "Behaviors/BehaviorBase.h"
#include "Events/EventRouter.h"

//! streams low-resolution ASCII-art of the camera image to sout
class ASCIIVisionBehavior : public BehaviorBase {
public:
	//! constructor
	ASCIIVisionBehavior() : BehaviorBase() {}

	static const unsigned int charMapSize=64;
	static const char charMap[charMapSize];

	virtual void DoStart() {
		BehaviorBase::DoStart(); // do this first
		erouter->addListener(this,EventBase::visRawCameraEGID);
	}

	virtual void DoStop() {
		erouter->removeListener(this);
		BehaviorBase::DoStop(); // do this last
	}

	virtual void processEvent(const EventBase& e);

	virtual std::string getName() const { return "ASCIIVisionBehavior"; }

	static std::string getClassDescription() { return "streams low-resolution ASCII-art of the camera image to sout"; }
	
protected:
	
};

/*! @file
 * @brief Defines ASCIIVisionBehavior, which streams low-resolution ASCII-art of the camera image to sout
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2004/10/19 00:46:54 $
 */

#endif
