/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class FTPDataSocket {
    private static String cvsId = "@(#)$Id: FTPDataSocket.java,v 1.3 2003/05/31 14:53:44 bruceb Exp $";
    private ServerSocket activeSocket = null;
    private Socket passiveSocket = null;

    FTPDataSocket(ServerSocket s) {
        this.activeSocket = s;
    }

    FTPDataSocket(Socket s) {
        this.passiveSocket = s;
    }

    void setTimeout(int millis) throws IOException {
        if (this.passiveSocket != null) {
            this.passiveSocket.setSoTimeout(millis);
        } else if (this.activeSocket != null) {
            this.activeSocket.setSoTimeout(millis);
        }
    }

    OutputStream getOutputStream() throws IOException {
        if (this.passiveSocket != null) {
            return this.passiveSocket.getOutputStream();
        }
        this.passiveSocket = this.activeSocket.accept();
        return this.passiveSocket.getOutputStream();
    }

    InputStream getInputStream() throws IOException {
        if (this.passiveSocket != null) {
            return this.passiveSocket.getInputStream();
        }
        this.passiveSocket = this.activeSocket.accept();
        return this.passiveSocket.getInputStream();
    }

    void close() throws IOException {
        if (this.passiveSocket != null) {
            this.passiveSocket.close();
        }
        if (this.activeSocket != null) {
            this.activeSocket.close();
        }
    }
}

