/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class FTPClient {
    private static String cvsId = "@(#)$Id: FTPClient.java,v 1.6 2003/05/31 14:53:44 bruceb Exp $";
    private SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private FTPControlSocket control = null;
    private FTPDataSocket data = null;
    private int timeout = 0;
    private FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode connectMode = FTPConnectMode.PASV;
    private FTPReply lastValidReply;

    public FTPClient(String remoteHost) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteHost, 21, null, 0);
    }

    public FTPClient(String remoteHost, int controlPort) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteHost, controlPort, null, 0);
    }

    public FTPClient(InetAddress remoteAddr) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteAddr, 21, null, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteAddr, controlPort, null, 0);
    }

    public FTPClient(String remoteHost, PrintWriter log, int timeout) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteHost, 21, log, timeout);
    }

    public FTPClient(String remoteHost, int controlPort, PrintWriter log, int timeout) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteHost, controlPort, log, timeout);
    }

    public FTPClient(InetAddress remoteAddr, PrintWriter log, int timeout) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteAddr, 21, log, timeout);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, PrintWriter log, int timeout) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteAddr, controlPort, log, timeout);
    }

    public void setTimeout(int millis) throws IOException {
        this.timeout = millis;
        this.control.setTimeout(millis);
    }

    public void setConnectMode(FTPConnectMode mode) {
        this.connectMode = mode;
    }

    public void login(String user, String password) throws IOException, FTPException {
        String response = this.control.sendCommand("USER " + user);
        this.lastValidReply = this.control.validateReply(response, "331");
        response = this.control.sendCommand("PASS " + password);
        this.lastValidReply = this.control.validateReply(response, "230");
    }

    public void user(String user) throws IOException, FTPException {
        String reply = this.control.sendCommand("USER " + user);
        String[] validCodes = new String[]{"230", "331"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void password(String password) throws IOException, FTPException {
        String reply = this.control.sendCommand("PASS " + password);
        String[] validCodes = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public static void initSOCKS(String port, String host) {
        Properties props = System.getProperties();
        props.put("socksProxyPort", port);
        props.put("socksProxyHost", host);
        System.setProperties(props);
    }

    public static void initSOCKSAuthentication(String username, String password) {
        Properties props = System.getProperties();
        props.put("java.net.socks.username", username);
        props.put("java.net.socks.password", password);
        System.setProperties(props);
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public void quote(String command, String[] validCodes) throws IOException, FTPException {
        String reply = this.control.sendCommand(command);
        if (validCodes != null && validCodes.length > 0) {
            this.lastValidReply = this.control.validateReply(reply, validCodes);
        }
    }

    public void put(String localPath, String remoteFile) throws IOException, FTPException {
        this.put(localPath, remoteFile, false);
    }

    public void put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        this.put(srcStream, remoteFile, false);
    }

    public void put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.putASCII(localPath, remoteFile, append);
        } else {
            this.putBinary(localPath, remoteFile, append);
        }
        this.validateTransfer();
    }

    public void put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.putASCII(srcStream, remoteFile, append);
        } else {
            this.putBinary(srcStream, remoteFile, append);
        }
        this.validateTransfer();
    }

    private void validateTransfer() throws IOException, FTPException {
        String[] validCodes = new String[]{"226", "250"};
        String reply = this.control.readReply();
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    private void initPut(String remoteFile, boolean append) throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String cmd = append ? "APPE " : "STOR ";
        String reply = this.control.sendCommand(cmd + remoteFile);
        String[] validCodes = new String[]{"125", "150"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    private void putASCII(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        FileInputStream srcStream = new FileInputStream(localPath);
        this.putASCII(srcStream, remoteFile, append);
    }

    private void putASCII(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        LineNumberReader in = new LineNumberReader(new InputStreamReader(srcStream));
        this.initPut(remoteFile, append);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.data.getOutputStream()));
        String line = null;
        while ((line = in.readLine()) != null) {
            out.write(line, 0, line.length());
            out.write("\r\n", 0, "\r\n".length());
        }
        in.close();
        out.flush();
        out.close();
        try {
            this.data.close();
        }
        catch (IOException ignore) {}
    }

    private void putBinary(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        FileInputStream srcStream = new FileInputStream(localPath);
        this.putBinary(srcStream, remoteFile, append);
    }

    private void putBinary(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        BufferedInputStream in = new BufferedInputStream(srcStream);
        this.initPut(remoteFile, append);
        BufferedOutputStream out = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()));
        byte[] buf = new byte[512];
        long size = 0L;
        int count = 0;
        while ((count = in.read(buf)) > 0) {
            out.write(buf, 0, count);
            size += (long)count;
        }
        in.close();
        out.flush();
        out.close();
        try {
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        this.control.log("Transferred " + size + " bytes to remote host");
    }

    public void put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        this.put(bytes, remoteFile, false);
    }

    public void put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        this.initPut(remoteFile, append);
        BufferedOutputStream out = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()));
        out.write(bytes, 0, bytes.length);
        out.flush();
        out.close();
        try {
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        this.validateTransfer();
    }

    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.getASCII(localPath, remoteFile);
        } else {
            this.getBinary(localPath, remoteFile);
        }
        this.validateTransfer();
    }

    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.getASCII(destStream, remoteFile);
        } else {
            this.getBinary(destStream, remoteFile);
        }
        this.validateTransfer();
    }

    private void initGet(String remoteFile) throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String reply = this.control.sendCommand("RETR " + remoteFile);
        String[] validCodes1 = new String[]{"125", "150"};
        this.lastValidReply = this.control.validateReply(reply, validCodes1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getASCII(String localPath, String remoteFile) throws IOException, FTPException {
        IOException storedEx;
        LineNumberReader in;
        block8: {
            this.initGet(remoteFile);
            File localFile = new File(localPath);
            BufferedWriter out = new BufferedWriter(new FileWriter(localPath));
            in = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
            this.data.setTimeout(this.timeout);
            storedEx = null;
            String line = null;
            try {
                try {
                    while ((line = in.readLine()) != null) {
                        out.write(line, 0, line.length());
                        out.newLine();
                    }
                }
                catch (IOException ex) {
                    storedEx = ex;
                    localFile.delete();
                    Object var10_9 = null;
                    out.close();
                    break block8;
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                out.close();
                throw throwable;
            }
            out.close();
        }
        try {
            in.close();
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (storedEx != null) {
            throw storedEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getASCII(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        IOException storedEx;
        LineNumberReader in;
        block8: {
            this.initGet(remoteFile);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(destStream));
            in = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
            this.data.setTimeout(this.timeout);
            storedEx = null;
            String line = null;
            try {
                try {
                    while ((line = in.readLine()) != null) {
                        out.write(line, 0, line.length());
                        out.newLine();
                    }
                }
                catch (IOException ex) {
                    storedEx = ex;
                    Object var9_8 = null;
                    out.close();
                    break block8;
                }
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                out.close();
                throw throwable;
            }
            out.close();
        }
        try {
            in.close();
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (storedEx != null) {
            throw storedEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getBinary(String localPath, String remoteFile) throws IOException, FTPException {
        IOException storedEx;
        long size;
        BufferedInputStream in;
        block8: {
            this.initGet(remoteFile);
            File localFile = new File(localPath);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localPath, false));
            in = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
            this.data.setTimeout(this.timeout);
            size = 0L;
            int chunksize = 4096;
            byte[] chunk = new byte[chunksize];
            storedEx = null;
            try {
                try {
                    int count;
                    while ((count = in.read(chunk, 0, chunksize)) >= 0) {
                        void var10_10;
                        out.write(chunk, 0, (int)var10_10);
                        size += (long)var10_10;
                    }
                }
                catch (IOException ex) {
                    storedEx = ex;
                    localFile.delete();
                    Object var14_12 = null;
                    out.close();
                    break block8;
                }
                Object var14_11 = null;
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                out.close();
                throw throwable;
            }
            out.close();
        }
        try {
            in.close();
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (storedEx != null) {
            throw storedEx;
        }
        this.control.log("Transferred " + size + " bytes from remote host");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getBinary(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        IOException storedEx;
        long size;
        BufferedInputStream in;
        block8: {
            this.initGet(remoteFile);
            BufferedOutputStream out = new BufferedOutputStream(destStream);
            in = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
            this.data.setTimeout(this.timeout);
            size = 0L;
            int chunksize = 4096;
            byte[] chunk = new byte[chunksize];
            storedEx = null;
            try {
                try {
                    int count;
                    while ((count = in.read(chunk, 0, chunksize)) >= 0) {
                        void var9_9;
                        out.write(chunk, 0, (int)var9_9);
                        size += (long)var9_9;
                    }
                }
                catch (IOException ex) {
                    storedEx = ex;
                    Object var13_11 = null;
                    out.close();
                    break block8;
                }
                Object var13_10 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                out.close();
                throw throwable;
            }
            out.close();
        }
        try {
            in.close();
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (storedEx != null) {
            throw storedEx;
        }
        this.control.log("Transferred " + size + " bytes from remote host");
    }

    /*
     * WARNING - void declaration
     */
    public byte[] get(String remoteFile) throws IOException, FTPException {
        int count;
        this.initGet(remoteFile);
        BufferedInputStream in = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        this.data.setTimeout(this.timeout);
        int chunksize = 4096;
        byte[] chunk = new byte[chunksize];
        byte[] resultBuf = null;
        ByteArrayOutputStream temp = new ByteArrayOutputStream(chunksize);
        while ((count = in.read(chunk, 0, chunksize)) >= 0) {
            void var7_7;
            temp.write(chunk, 0, (int)var7_7);
        }
        temp.close();
        resultBuf = temp.toByteArray();
        try {
            in.close();
            this.data.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        this.validateTransfer();
        return resultBuf;
    }

    public boolean site(String command) throws IOException, FTPException {
        String reply = this.control.sendCommand("SITE " + command);
        String[] validCodes = new String[]{"200", "202", "502"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return reply.substring(0, 3).equals("200");
    }

    public String list(String dirname) throws IOException, FTPException {
        return this.list(dirname, false);
    }

    public String list(String dirname, boolean full) throws IOException, FTPException {
        String[] list = this.dir(dirname, full);
        StringBuffer result = new StringBuffer();
        String sep = System.getProperty("line.separator");
        int i = 0;
        while (i < list.length) {
            result.append(list[i]);
            result.append(sep);
            ++i;
        }
        return result.toString();
    }

    public String[] dir() throws IOException, FTPException {
        return this.dir(null, false);
    }

    public String[] dir(String dirname) throws IOException, FTPException {
        return this.dir(dirname, false);
    }

    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        String command;
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String string = command = full ? "LIST " : "NLST ";
        if (dirname != null) {
            command = command + dirname;
        }
        command = command.trim();
        String reply = this.control.sendCommand(command);
        String[] validCodes1 = new String[]{"125", "150", "450", "550"};
        this.lastValidReply = this.control.validateReply(reply, validCodes1);
        String[] result = new String[]{};
        String replyCode = this.lastValidReply.getReplyCode();
        if (!replyCode.equals("450") && !replyCode.equals("550")) {
            LineNumberReader in = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
            Vector<String> lines = new Vector<String>();
            String line = null;
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            try {
                in.close();
                this.data.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            String[] validCodes2 = new String[]{"226", "250"};
            reply = this.control.readReply();
            this.lastValidReply = this.control.validateReply(reply, validCodes2);
            if (!lines.isEmpty()) {
                result = lines.toArray(result);
            }
        }
        return result;
    }

    public FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    public void debugResponses(boolean on) {
        this.control.debugResponses(on);
    }

    public void setLogStream(PrintWriter log) {
        this.control.setLogStream(log);
    }

    public FTPTransferType getType() {
        return this.transferType;
    }

    public void setType(FTPTransferType type) throws IOException, FTPException {
        String typeStr = FTPTransferType.ASCII_CHAR;
        if (type.equals(FTPTransferType.BINARY)) {
            typeStr = FTPTransferType.BINARY_CHAR;
        }
        String reply = this.control.sendCommand("TYPE " + typeStr);
        this.lastValidReply = this.control.validateReply(reply, "200");
        this.transferType = type;
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        String reply = this.control.sendCommand("DELE " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, "250");
    }

    public void rename(String from, String to) throws IOException, FTPException {
        String reply = this.control.sendCommand("RNFR " + from);
        this.lastValidReply = this.control.validateReply(reply, "350");
        reply = this.control.sendCommand("RNTO " + to);
        this.lastValidReply = this.control.validateReply(reply, "250");
    }

    public void rmdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("RMD " + dir);
        String[] validCodes = new String[]{"250", "257"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void mkdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("MKD " + dir);
        this.lastValidReply = this.control.validateReply(reply, "257");
    }

    public void chdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("CWD " + dir);
        this.lastValidReply = this.control.validateReply(reply, "250");
    }

    public Date modtime(String remoteFile) throws IOException, FTPException {
        String reply = this.control.sendCommand("MDTM " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, "213");
        Date ts = this.tsFormat.parse(this.lastValidReply.getReplyText(), new ParsePosition(0));
        return ts;
    }

    public String pwd() throws IOException, FTPException {
        String reply = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(reply, "257");
        String text = this.lastValidReply.getReplyText();
        int start = text.indexOf(34);
        int end = text.lastIndexOf(34);
        if (start >= 0 && end > start) {
            return text.substring(start + 1, end);
        }
        return text;
    }

    public String system() throws IOException, FTPException {
        String reply = this.control.sendCommand("SYST");
        this.lastValidReply = this.control.validateReply(reply, "215");
        return this.lastValidReply.getReplyText();
    }

    public String help(String command) throws IOException, FTPException {
        String reply = this.control.sendCommand("HELP " + command);
        String[] validCodes = new String[]{"211", "214"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException, FTPException {
        try {
            String reply = this.control.sendCommand("QUIT");
            String[] validCodes = new String[]{"221", "226"};
            this.lastValidReply = this.control.validateReply(reply, validCodes);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.control.logout();
            this.control = null;
            throw throwable;
        }
        this.control.logout();
        this.control = null;
    }
}

