import java.awt.image.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

public class VisionFilter {
  static final int size_y=16;
  static final int size_u=64;
  static final int size_v=64;
  
  public static void main(String args[]) {
    if (args.length!=2) {
      System.out.println("usage: java VisionFilter infile outfile");
      System.exit(0);
    }
    VisionFilter filter=new VisionFilter(args[0], args[1]);
  }

  public VisionFilter (String infile, String outfile) {
    try {
      FileInputStream in=new FileInputStream(infile);
      FileOutputStream out=new FileOutputStream(outfile);

      byte[] tmdata=new byte[65536];
      in.read(tmdata,0,19);
      out.write(tmdata,0,19);
      in.read(tmdata);

      filter(tmdata);

      out.write(tmdata);
      in.close();
      out.close();
    } catch (Exception ex) {
      System.out.println(ex);
    }
  }

  void filter(byte[] data) {
    int y, u, v;
    int cnt=0; 
    for (y=0; y<16; y++)
      for (u=0; u<64; u++)
        for (v=0; v<64; v++)
          if (data[offset(y, u, v)]==1) {
            data[offset(y, u, v)]=9;
            cnt++;
          }
    System.out.println(cnt);
  }

  static final int offset(int y, int u, int v) {
    return (y*size_u+u)*size_v+v;
  }
}
