//-*-c++-*-
#ifndef INCLUDED_VisualTargetCloseTrans_h_
#define INCLUDED_VisualTargetCloseTrans_h_

#include "Events/EventRouter.h"
#include "Events/VisionObjectEvent.h"
#include "Shared/debuget.h"
#include "Shared/WorldState.h"
#include "Shared/ERS210Info.h"
#include "Shared/ERS220Info.h"
#include "Shared/ERS7Info.h"

//! causes a transition when a visual object is "close"
class VisualTargetCloseTrans : public Transition {
public:
	//!constructor
	VisualTargetCloseTrans(StateNode* destination, unsigned int source_id) : Transition("VisualTargetCloseTrans",destination), sid(source_id) {}

	//!constructor
	VisualTargetCloseTrans(const std::string& name, StateNode* destination, unsigned int source_id) : Transition("VisualTargetCloseTrans",name,destination), sid(source_id) {}

	//!starts listening for the object specified by the source id in the constructor
	virtual void DoStart() { Transition::DoStart(); erouter->addListener(this,EventBase::visObjEGID,sid); }

	//!called by StateNode when it becomes inactive - undo whatever you did in Enable()
	virtual void DoStop() { erouter->removeListener(this); Transition::DoStop(); }

	//!if the object is "close", calls fire()
	virtual void processEvent(const EventBase& e) {
		const VisionObjectEvent* ve=dynamic_cast<const VisionObjectEvent*>(&e);
		ASSERTRET(ve!=NULL,"Casting error");
		float x=ve->getCenterX();
		float y=ve->getCenterY();
		unsigned int IRDistOffset=-1U;
		//The ERS-7 adds more IR distance sensors, so we have to
		//break it down by model so we can specify which one
		if(state->robotDesign & WorldState::ERS210Mask)
			IRDistOffset=ERS210Info::IRDistOffset;
		else if(state->robotDesign & WorldState::ERS220Mask)
			IRDistOffset=ERS220Info::IRDistOffset;
		else if(state->robotDesign & WorldState::ERS7Mask)
			IRDistOffset=ERS7Info::NearIRDistOffset;
		if(x*x+y*y<0.02f && IRDistOffset!=-1U && state->sensors[IRDistOffset]<225)
			fire();
	}

protected:
	//!Source ID of object to track
	unsigned int sid;
};

/*! @file
 * @brief Defines VisualTargetCloseTrans, which causes a transition when a visual object is "close"
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_2 $
 * $Revision: 1.14 $
 * $State: Exp $
 * $Date: 2004/11/15 22:46:19 $
 */

#endif
