#include "Transition.h"
#include "StateNode.h"
#include "Wireless/Wireless.h"
#include "SoundPlay/SoundManager.h"
#include "Events/EventRouter.h"

/*! @deprecated, use the version of the constructor where you can pass a name */
Transition::Transition() : BehaviorBase("Transition"), srcs(), dsts(), sound() {}

/*! @deprecated, use the version of the constructor where you can pass a name */
Transition::Transition(StateNode* destination)
	: BehaviorBase("Transition"), srcs(), dsts(), sound()
{
	addDestination(destination);
}


/*! @deprecated: use #fire() instead (just a better name) */
void Transition::activate() {
	serr->printf("Transition::activate() is deprecated.  Use Transition::fire() instead.\n");
	fire();
}

void Transition::fire() {
	//serr->printf("%s fire() - enter %d\n",getName().c_str(),get_time());

	AddReference(); //just in case a side effect of this transition is to dereference the transition, we don't want to be deleted while still transitioning

	if(sound.size()!=0)
		sndman->PlayFile(sound);

	erouter->postEvent(EventBase::stateTransitionEGID,reinterpret_cast<int>(this),EventBase::statusETID,0,getName(),1);

	for(unsigned int i=0; i<srcs.size(); i++)
		if(srcs[i]->isActive()) //It's usually a bad idea to call DoStop/DoStart when it's already stopped/started...
			srcs[i]->DoStop();
	for(unsigned int i=0; i<dsts.size(); i++)
		if(!dsts[i]->isActive())
			dsts[i]->DoStart();

	//serr->printf("%s fire() - leave %d\n",getName().c_str(),get_time());
	RemoveReference();
}

std::string Transition::getName() const {
	if(instanceName != className) {
		return instanceName;
	} else {
		std::string ans;
		ans+='{';
		for(unsigned int i=0; i<srcs.size(); i++)
			ans+=srcs[i]->getName()+(i<srcs.size()-1?',':'}');
		ans+="--"+instanceName+"-->";
		ans+='{';
		for(unsigned int i=0; i<dsts.size(); i++)
			ans+=dsts[i]->getName()+(i<srcs.size()-1?',':'}');
		return ans;
	}
} 

/*! @file
 * @brief Implements Transition, represents a transition between StateNodes.
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_2 $
 * $Revision: 1.13 $
 * $State: Exp $
 * $Date: 2004/12/17 05:51:32 $
 */

