//-*-c++-*-
#ifndef INCLUDED_PlayMotionSequenceNode_h_
#define INCLUDED_PlayMotionSequenceNode_h_

#include "Behaviors/StateNode.h"
#include "Motion/MotionManager.h"
#include "Motion/MotionSequenceMC.h"

//! A StateNode for playing a MotionSequence (and looping it if desired)
/*! Eventually, i'd like to just build the looping functionality into
 *  MotionSequence, but in the mean time we have this. */
template<unsigned int SIZE>
class PlayMotionSequenceNode : public StateNode {
public:
	//!constructor
	PlayMotionSequenceNode()
		: StateNode("PlayMotionSequenceNode","PlayMotionSequenceNode"), msid(MotionManager::invalid_MC_ID), msidIsMine(false), looping(false), filename()
	{}

	//!constructor
	PlayMotionSequenceNode(const std::string& nm, const std::string& file, bool loop=false)
		: StateNode("PlayMotionSequenceNode",nm), msid(MotionManager::invalid_MC_ID), msidIsMine(false), looping(false), filename(file)
	{
		setLooping(loop);
	}

	virtual void setup() {}

	virtual void DoStart() {
		//std::cout << "PlayMotionSequenceNode::DoStart(); " << std::endl;
		updateMS(filename);
		erouter->addListener(this, EventBase::motmanEGID);//, msid, EventBase::deactivateETID);
		StateNode::DoStart();
	}

	virtual void DoStop() {
		//std::cout << "PlayMotionSequenceNode::DoStop(); " << std::endl;
		erouter->removeListener(this);
		motman->removeMotion(msid);
		msid=MotionManager::invalid_MC_ID;
		StateNode::DoStop();
	}

	virtual void teardown() {
		if(msidIsMine) {
			motman->removeMotion(msid);
			msid=MotionManager::invalid_MC_ID;
		}
	}

	/* not ready yet
	// ! use this to force the PlayMotionSequenceNode to use a shared MS - set to MotionManager::invalid_MC_ID to reset to internally generated MS
	virtual void setMSid(MotionManager::MC_ID id) {
	if(msidIsMine) {
	motman->removeMotion(msid);
	msid=MotionManager::invalid_MC_ID;
	}
	msid=id;
	msidIsMine=(id==MotionManager::invalid_MC_ID);
	}
	*/

	//! sets the file to play
	virtual void setFile(const std::string& file) {
		if(isActive())
			updateMS(file);
		else
			filename=file;
	}

	//! turns looping on or off
	virtual void setLooping(bool loop) { looping=loop; }

	virtual void processEvent(const EventBase& e) {
		ASSERTRET(e.getGeneratorID()==EventBase::motmanEGID,"Unknown event");
		if(e==EventBase(EventBase::motmanEGID,msid,EventBase::deactivateETID)) {
			msid=MotionManager::invalid_MC_ID;
			if(looping) {
				updateMS(filename);
			}
			erouter->postEvent(EventBase::stateMachineEGID,reinterpret_cast<unsigned int>(this),EventBase::statusETID,0,getName(),1);
		}
	}

	//! returns true if currently looping
	virtual bool getLooping() { return looping; }

	//! use this to access the MS that the PlayMotionSequenceNode is using
	virtual MotionManager::MC_ID getMSid() { return msid; }

	//! use this to access the MS that the PlayMotionSequenceNode is using
	virtual MMAccessor<MotionSequenceMC<SIZE> > getMSAccessor() { return MMAccessor<MotionSequenceMC<SIZE> >(msid); }

	//! returns true if #msid was created (and will be destroyed) by this PlayMotionSequenceNode - false if assigned by setMsid()
	virtual bool ownsMSid() { return msidIsMine; }

protected:
	//! resets the motion command and starts it playing
	void updateMS(const std::string& file) {
		if(msid==MotionManager::invalid_MC_ID) {
			msid=motman->addPrunableMotion(SharedObject<MotionSequenceMC<SIZE> >(file.c_str()));
			msidIsMine=true;
		} else {
			MMAccessor<MotionSequenceMC<SIZE> > ms(msid);
			ms->clear();
			ms->LoadFile(file.c_str());
			ms->setTime(1);
		}
		filename=file;
	}

	MotionManager::MC_ID msid; //!< id of the motion command
	bool msidIsMine; //!< true if this class created the current motion command (and therefore should delete it when done)
	bool looping; //!< true if we should loop
	std::string filename; //!< filename of current motion sequence
};

typedef PlayMotionSequenceNode<TinyMotionSequenceMC::CAPACITY> TinyPlayMotionSequenceNode; //!< streamlined access to the standard template sizes
typedef PlayMotionSequenceNode<SmallMotionSequenceMC::CAPACITY> SmallPlayMotionSequenceNode; //!< streamlined access to the standard template sizes
typedef PlayMotionSequenceNode<MediumMotionSequenceMC::CAPACITY> MediumPlayMotionSequenceNode; //!< streamlined access to the standard template sizes
typedef PlayMotionSequenceNode<LargeMotionSequenceMC::CAPACITY> LargePlayMotionSequenceNode; //!< streamlined access to the standard template sizes
typedef PlayMotionSequenceNode<XLargeMotionSequenceMC::CAPACITY> XLargePlayMotionSequenceNode; //!< streamlined access to the standard template sizes

/*! @file
 * @brief Describes PlayMotionSequenceNode, a StateNode for playing a MotionSequence (and looping it if desired)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_2 $
 * $Revision: 1.12 $
 * $State: Exp $
 * $Date: 2004/12/21 21:49:50 $
 */

#endif
