//-*-c++-*-
#ifndef INCLUDED_WorldStateSerializer_h
#define INCLUDED_WorldStateSerializer_h

#include "Behaviors/BehaviorBase.h"
#include "Shared/Config.h"

class Socket;

//! Copies WorldState into a buffer for transmission over the network
/*! To determine the communication protocol, just look in the
 *  processEvent() function - it's pretty straightforward binary copy
 *  of values */
class WorldStateSerializerBehavior : public BehaviorBase {
public:
  WorldStateSerializerBehavior(); //!< constructor

	virtual void DoStart(); //!< starts listening for sensor update events
	virtual void DoStop(); //!< stops listening for events
	virtual void processEvent(const EventBase& e); //!< core functionality - performs serialization, sends to sockets
	static std::string getClassDescription() {
		char tmp[80];
		sprintf(tmp,"Sends sensor information to port %d and current pid values to port %d",config->main.wsjoints_port,config->main.wspids_port);
		return tmp;
	}
	virtual std::string getDescription() const { return getClassDescription(); }

protected:
	//! writes @a value to @a dst and advances @a dst
  template<class T>
  inline static void encode(char **dst, const T& value) {
    memcpy(*dst, &value, sizeof(T));
		// it'd be nice to use network byte order, but we'll save the aibo extra work
		//hostToNetwork(*dst, (char *)&value, sizeof(T));
    (*dst) += sizeof(T);
  }

	//! writes @a length bytes from @a src to @a dst
  template<class T>
  inline static void encode(char **dst, const T * src, int num) {
    memcpy(*dst, src, num*sizeof(T));
    (*dst) += num*sizeof(T);
  }

  Socket *wsJoints; //!< socket for sending current joint data
  Socket *wsPIDs; //!< socket for sending current PID info

private:
  WorldStateSerializerBehavior(const WorldStateSerializerBehavior&); //!< don't call
  WorldStateSerializerBehavior& operator= (const WorldStateSerializerBehavior&); //!< don't call
};

/*! @file
 * @brief Describes WorldStateSerializerBehavior, which copies WorldState into a buffer for transmission over the network
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_2 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2004/11/11 01:45:36 $
 */

#endif
