#include "WorldStateSerializerBehavior.h"
#include "Shared/WorldState.h"
#include "Wireless/Wireless.h"
#include "Shared/Config.h"
#include "Events/EventRouter.h"

WorldStateSerializerBehavior::WorldStateSerializerBehavior()
	: BehaviorBase("WorldStateSerializerBehavior"), wsJoints(NULL), wsPIDs(NULL)
{
	wsJoints=wireless->socket(SocketNS::SOCK_STREAM, 1024, 2048);
  wireless->setDaemon(wsJoints);
  wireless->listen(wsJoints, config->main.wsjoints_port);
  wsPIDs=wireless->socket(SocketNS::SOCK_STREAM, 1024, 2048);
  wireless->setDaemon(wsPIDs);
	wireless->listen(wsPIDs, config->main.wspids_port);
}

void WorldStateSerializerBehavior::DoStart() {
	BehaviorBase::DoStart(); // do this first
	erouter->addListener(this,EventBase::sensorEGID);
}

void WorldStateSerializerBehavior::DoStop() {
	erouter->removeListener(this);
	BehaviorBase::DoStop(); // do this last
}

void WorldStateSerializerBehavior::processEvent(const EventBase& /*e*/) {
  char *buf=(char*)wsPIDs->getWriteBuffer((NumPIDJoints*3)*sizeof(float)+2*sizeof(unsigned int));
  if (buf) {
    encode(&buf,state->lastSensorUpdateTime);
		encode(&buf,NumPIDJoints);
    encode(&buf,state->pids,NumPIDJoints*3);
    wsPIDs->write((NumPIDJoints*3)*sizeof(float)+2*sizeof(unsigned int));
  }
  
  buf=(char*)wsJoints->getWriteBuffer((NumPIDJoints*2+NumSensors+NumButtons)*sizeof(float)+4*sizeof(unsigned int));
  if (buf) {
    encode(&buf,state->lastSensorUpdateTime);
		encode(&buf,NumPIDJoints);
    encode(&buf,&state->outputs[PIDJointOffset], NumPIDJoints);
		encode(&buf,NumSensors);
    encode(&buf,state->sensors,NumSensors);
		encode(&buf,NumButtons);
    encode(&buf,state->buttons,NumButtons);
    encode(&buf,state->pidduties,NumPIDJoints);
    wsJoints->write((NumPIDJoints*2+NumSensors+NumButtons)*sizeof(float)+4*sizeof(unsigned int));
  }
}

/*! @file
 * @brief Implements WorldStateSerializer, which copies WorldState into a buffer for transmission over the network
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_2 $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2004/11/11 01:45:36 $
 */
