//-*-c++-*-
#ifndef INCLUDED_HelloWorldBehavior_h_
#define INCLUDED_HelloWorldBehavior_h_

#include "Behaviors/BehaviorBase.h"
#include "Wireless/Wireless.h"

//! Demonstrates serr, sout, and cout
class HelloWorldBehavior : public BehaviorBase {
public:
	//Note that we pass the name of our class as an argument to the
	//BehaviorBase constructor.  This is used for the default name for
	//instances of this class, and may allow more readable debugging
	//information
	HelloWorldBehavior() : BehaviorBase("HelloWorldBehavior")	{}
	
	virtual void DoStart() {
		//call superclass first for housekeeping:
		BehaviorBase::DoStart();

		//now do your code:
		for(unsigned int i=0; i<100; i++)
			serr->printf("Hello serr!  This is %d\n",i);
		for(unsigned int i=0; i<10; i++)
			sout->printf("Hello sout!  This is %d\n",i);
		for(unsigned int i=0; i<10; i++)
			cout << "Hello cout!  This is " << i << endl;
		for(unsigned int i=0; i<10; i++)
			printf("Hello printf!  This is %d\n",i);

		//we'll just stop right away since this Behavior has no 'active' state.
		DoStop(); //Note that you could also override this DoStop function...
	}
	
	static std::string getClassDescription() {
		// This string will be shown by the HelpControl or by the tooltips
		// of the Controller GUI (not required, but nice)
		return "A little demo of text output";
	}
	virtual std::string getDescription() const {
		// We override this function to return the string we supplied
		// above (not required, but nice)
		return getClassDescription();
	}
	
};

/*! @file
 * @brief Defines HelloWorldBehavior, a little demo of text output (serr, sout, and cout)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_2 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2004/11/11 01:45:36 $
 */

#endif
