//-*-c++-*-
#ifndef INCLUDED_ExploreMachine_h_
#define INCLUDED_ExploreMachine_h_

#include "Behaviors/StateNode.h"
#include "Motion/MotionManager.h"

//! A state machine for exploring an environment (or searching for an object)
class ExploreMachine : public StateNode {
public:
	//!constructor
	ExploreMachine()
		: StateNode("ExploreMachine","ExploreMachine"), start(NULL), turn(NULL), walkid(MotionManager::invalid_MC_ID)
	{}

	//!constructor
	ExploreMachine(const std::string& nm)
		: StateNode("ExploreMachine",nm), start(NULL), turn(NULL), walkid(MotionManager::invalid_MC_ID)
	{}

	virtual void setup();
	virtual void DoStart();
	virtual void DoStop();
	virtual void teardown();

	//! called each time the turn node is activated, sets a new random turn direction and speed
	virtual void processEvent(const EventBase& /*e*/);

protected:
	StateNode * start; //!< the node to begin within on DoStart() (turn)
	class WalkNode * turn; //!< walk node to use when turning
	MotionManager::MC_ID walkid; //!< we want to share a walk between turning and walking nodes

private:
	ExploreMachine(const ExploreMachine&); //!< don't use
	ExploreMachine operator=(const ExploreMachine&); //!< don't use
};

/*! @file
 * @brief Describes ExploreMachine, a state machine for exploring an environment (or searching for an object)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_2 $
 * $Revision: 1.22 $
 * $State: Exp $
 * $Date: 2004/12/04 00:10:38 $
 */

#endif
