#include "BehaviorBase.h"

std::set<BehaviorBase*> BehaviorBase::registry;

/*! @deprecated, behavior constructors should take a name argument (which by default should be the name of the type of the class) */
BehaviorBase::BehaviorBase()
	: ReferenceCounter(), EventListener(), started(false),
	  instanceName("?"), className("BehaviorBase")
{
	registry.insert(this);
}

BehaviorBase::BehaviorBase(const std::string& name)
	: ReferenceCounter(), EventListener(), started(false),
	  instanceName(name), className(name)
{
	registry.insert(this);
}

BehaviorBase::BehaviorBase(const std::string& classname, const std::string& instancename)
	: ReferenceCounter(), EventListener(), started(false),
	  instanceName(instancename), className(classname)
{
	registry.insert(this);
}


BehaviorBase::BehaviorBase(const BehaviorBase& b)
	: ReferenceCounter(b), EventListener(b), started(b.started),
	  instanceName(b.instanceName), className(b.className)
{
	registry.insert(this);
}

BehaviorBase&
BehaviorBase::operator=(const BehaviorBase& b) {
	ReferenceCounter::operator=(b);
	EventListener::operator=(b);
	started=b.started;
	instanceName=b.instanceName;
	return *this;
}

BehaviorBase::~BehaviorBase() {
	SetAutoDelete(false);
	if(started)
		DoStop();
	//{ if(started) { references++; DoStop(); references--; } }
	registry.erase(this);
}

void
BehaviorBase::DoStart() {
	//std::cout << getName() << " started " << this << std::endl;
	if(!started) {
		started=true;
		AddReference();
	}
}

void
BehaviorBase::DoStop() {
	//std::cout << getName() << " stopped " << this << std::endl;
	if(started) {
		started=false;
		RemoveReference();
	}
}

