package org.tekkotsu.mon;

import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.lang.String;
//import java.util.LinkedList;
import java.awt.*;
import javax.imageio.ImageIO;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Date;
import java.util.Vector;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Comparator;
import java.io.PrintWriter;
import java.io.FileOutputStream;
import java.util.prefs.Preferences;
import java.io.File;
import java.net.*;
import java.io.*;
import java.util.StringTokenizer;

public class SketchGUI extends JFrame implements ActionListener,TreeSelectionListener {
	boolean isCam; // true if this GUI is displaying a camera space (not world)

	JFrame sketchFrame;
    SketchPanel sketchPanel;
//    JButton spawnBut;
    JButton refreshBut;
    JButton saveImageBut;
	JButton refreshListBut;
    JTree sketchTree;
	DefaultMutableTreeNode root; //= new DefaultMutableTreeNode("camspace");
    JLabel status;
    float mspf=0;
    float mspfGamma=.9f;
    String state="";
    String host;
    int listingPort;
	int sketchPort;
//    static int defListPort = 5800; // Default Port
 //   static int defSketchPort = 5801; // Default Port
    static Preferences prefs = Preferences.userNodeForPackage(SketchGUI.class);
	// the socket over which listings are retrieved and Sketch commands are sent
	Socket listingSocket=null;
	PrintWriter netout = null; // network output
    BufferedReader netin = null; // network input

    public static void main(String args[]) {
	if(args.length<4)
	     usage();

    //listingPort=Integer.parseInt(args[2]);
	int _listingPort = Integer.parseInt(args[2]);
	int _sketchPort = Integer.parseInt(args[3]);
 //   sketchPort=Integer.parseInt(args[3]);

	boolean _isCam = args[1].equals("cam");
	SketchGUI gui = new SketchGUI(args[0], _listingPort, _sketchPort, _isCam);
//	gui.listingPort = _listingPort;
//	gui.sketchPort = Integer.parseInt(args[3]);
	gui.addWindowListener(new WindowAdapter() {
		 public void windowClosing(WindowEvent e) {}});
	gui.show();
    }
		
    public static void usage() {
	System.out.println("Usage: java org/tekkotsu/mon/SketchGUI host [cam/world] listport sketchport");
//	System.out.println("       if port is not specified, it defaults to: [12345]"); // Default port
	System.exit(2);
    }
			
    public void actionPerformed(ActionEvent e) {
//	if(e.getActionCommand().compareTo("spawn")==0) {
//	    SketchGUI gui = new SketchGUI(host,port);
//	    gui.addWindowListener(new WindowAdapter() {
//		     public void windowClosing(WindowEvent e) {
//		     }});
//	    gui.show();
	if(e.getActionCommand().compareTo("refresh")==0) {
		// reset bounds
		sketchPanel.leftBound = 0;
		sketchPanel.rightBound = 176;
		sketchPanel.topBound = 0;
		sketchPanel.bottomBound = 144;
/*		Enumeration nodes = root.breadthFirstEnumeration();
		nodes.nextElement(); //skip the root
		while (nodes.hasMoreElements()) {
			VisualObjectInfo oinfo = (VisualObjectInfo)(((DefaultMutableTreeNode)(nodes.nextElement())).getUserObject());
			sketchPanel.scaleToVisualObject(oinfo);
		}*/

		TreePath[] paths = sketchTree.getSelectionPaths();
		for (int path_i = 0; path_i < paths.length; path_i++) {
			DefaultMutableTreeNode node 
				=(DefaultMutableTreeNode)(paths[path_i].getLastPathComponent());
		
			if (node == root) continue;
			VisualObjectInfo vinfo = (VisualObjectInfo)(node.getUserObject());
			sketchPanel.scaleToVisualObject(vinfo);
		}

		Graphics2D g = sketchPanel._image.createGraphics();
		g.setBackground(Color.GRAY);
		g.clearRect(0,0,176,144);
		sketchPanel.repaint();
		valueChanged(null); // redraw
		sketchPanel.repaint();
		valueChanged(null); // redraw
	} else if(e.getActionCommand().compareTo("saveimg")==0) {
	    File cursavepath = new File(prefs.get("cursavepath",""));
	    JFileChooser dia=new JFileChooser(cursavepath);
	    dia.setDialogTitle("Save Image...");
	    Component cur=this;
	    while(cur.getParent()!=null)
		 cur=cur.getParent();
	    if(dia.showSaveDialog(cur)==JFileChooser.APPROVE_OPTION) {
		prefs.put("cursavepath",dia.getCurrentDirectory().getPath());
		String base=dia.getSelectedFile().getName();
		String format;
		if(base.lastIndexOf('.')==-1) {
		    format="png";
		} else {
		    int i=base.lastIndexOf(".");
		    format=base.substring(i+1);
		    base=base.substring(0,i);
		}
		try {
			FileOutputStream fileout=new FileOutputStream(dia.getSelectedFile().getParent()+File.separator+base+"."+format);
			ImageIO.write(sketchPanel.getListener().getImage(),format,fileout);
		} catch(Exception ex) {}
	    }
	} else if(e.getActionCommand().compareTo("refreshlist")==0) {
		// send command to refresh the sketch tree list
		netout.println("list");
//		DefaultMutableTreeNode root = new DefaultMutableTreeNode("camspace");
		root.removeAllChildren();
		// read in new sketch listing
		try {
			// reset bounds
			sketchPanel.leftBound = 0;
			sketchPanel.rightBound = 176;
			sketchPanel.topBound = 0;
			sketchPanel.bottomBound = 144;

			String inputLine;
			System.out.println(inputLine = netin.readLine());
			while((inputLine=netin.readLine()).compareTo("list end") != 0) {
				// parse type (sketch or shape)	
				StringTokenizer st = new StringTokenizer(inputLine,": ");
				String type = st.nextToken();

				// parse id
				inputLine = netin.readLine();
				st = new StringTokenizer(inputLine,": ");
				st.nextToken();
				int id = Integer.parseInt(st.nextToken());
				
				//parse parentId
				inputLine = netin.readLine();
				st = new StringTokenizer(inputLine,": ");
				st.nextToken();
				int parentId = Integer.parseInt(st.nextToken());
			
				// parse name
				inputLine = netin.readLine();
				st = new StringTokenizer(inputLine,":\r\n");
				st.nextToken();
				String name = st.nextToken();

				// create node
				System.out.println(type + " id:"+id+"parentId:"+parentId+"name:"+name);
				VisualObjectInfo oinfo;
				if(type.equals("sketch")) {
					oinfo = new SketchInfo(id, parentId, name);
				} else if (type.equals("shape")) {
					inputLine = netin.readLine();
					st = new StringTokenizer(inputLine,": ");
					st.nextToken();
					int shapetype = Integer.parseInt(st.nextToken());
					System.out.println("shapetype:" + shapetype);

					// parse shape color
					inputLine = netin.readLine();
					st = new StringTokenizer(inputLine,": ");
					st.nextToken();
					int color = Integer.parseInt(st.nextToken());
					System.out.println("color:" + color);

					inputLine = netin.readLine();
					st = new StringTokenizer(inputLine,": ");
					st.nextToken();
					float cx = Float.parseFloat(st.nextToken());
					float cy = Float.parseFloat(st.nextToken());
					float cz = Float.parseFloat(st.nextToken());
					System.out.println("cxyz:" +cx+" "+cy+" "+cz);

					if(shapetype == 1) { // lineshape
						inputLine = netin.readLine();
						st = new StringTokenizer(inputLine,": ");
						st.nextToken();
						float e1x = Float.parseFloat(st.nextToken());
						float e1y = Float.parseFloat(st.nextToken());
						float e1v = Float.parseFloat(st.nextToken());
						System.out.println("e1xyv:"+e1x+" "+e1y +" "+e1v);

						inputLine = netin.readLine();
						st = new StringTokenizer(inputLine,": ");
						st.nextToken();
						float e2x = Float.parseFloat(st.nextToken());
						float e2y = Float.parseFloat(st.nextToken());
						float e2v = Float.parseFloat(st.nextToken());
						System.out.println("e1xyv:"+e1x+" "+e1y +" "+e1v);

						inputLine = netin.readLine();
						st = new StringTokenizer(inputLine,": ");
						st.nextToken();
						float r = Float.parseFloat(st.nextToken());
						System.out.println("r:"+r);

						inputLine = netin.readLine();
						st = new StringTokenizer(inputLine,": ");
						st.nextToken();
						float theta = Float.parseFloat(st.nextToken());
						System.out.println("theta:"+theta);

						oinfo = new LineShapeInfo(id, parentId, name, color,
							cx,cy,cz, e1x, e1y, e1v, e2x, e2y, e2v, r, theta);

					} else if(shapetype == 2) { // ellipseshape
						inputLine = netin.readLine();
						st = new StringTokenizer(inputLine,": ");
						st.nextToken();
						float semimajor = Float.parseFloat(st.nextToken());
						float semiminor = Float.parseFloat(st.nextToken());
						System.out.println("axes:"+semimajor+" "+semiminor);

						inputLine = netin.readLine();
						st = new StringTokenizer(inputLine,": ");
						st.nextToken();
						float orientation = Float.parseFloat(st.nextToken());
						System.out.println("orientation:"+orientation);

						oinfo = new EllipseShapeInfo(id,parentId,name,color,
								cx,cy,cz, semimajor, semiminor, orientation);

					} else if (shapetype == 4) { // agentshape
						inputLine = netin.readLine();
						st = new StringTokenizer(inputLine,": ");
						st.nextToken();
						float orientation = Float.parseFloat(st.nextToken());
						System.out.println("orientation:"+orientation);

						oinfo = new AgentShapeInfo(id,parentId, name, color,
								cx,cy,cz, orientation);
					} else {
						System.out.println("Invalid shape!");
						oinfo = new ShapeInfo(id, parentId, name, color,
								cx,cy,cz);
					}
				} else {
					System.out.println("Invalid type!");
					oinfo = new VisualObjectInfo(id, parentId, name);
				}
	
				if(!isCam)
					sketchPanel.scaleToVisualObject(oinfo);

				DefaultMutableTreeNode newnode = new DefaultMutableTreeNode(oinfo);
				root.add(newnode);


				sketchTree.updateUI();
				
			}
			// pair up nodes with parents, quite inefficiently (?)
//			Enumeration nodes = root.preorderEnumeration();
//			while(nodes.hasMoreElements()) {
//				SketchInfo cur = (SketchInfo)(nodes.nextElement());
//				while(nodes.hasMoreElements()) {
//					
//				}
//			}
			// pair children with parents
			DefaultMutableTreeNode curNode = root;
			while((curNode = curNode.getNextNode()) != null) {
				DefaultMutableTreeNode potentialParent = root;
				while((potentialParent = potentialParent.getNextNode()) != null) {
					if(((VisualObjectInfo)(curNode.getUserObject())).parentId == ((VisualObjectInfo)(potentialParent.getUserObject())).id && !potentialParent.isNodeAncestor(curNode)) {
						potentialParent.add(curNode);
					}
				}

			}
			sortTree(root);		

			// display the first sketch
			SketchInfo firstinfo = (SketchInfo)(((DefaultMutableTreeNode)(root.getFirstChild())).getUserObject());
			netout.println("get "+firstinfo.getId());
			while((inputLine=netin.readLine()).compareTo("get end") != 0) {
				System.out.println(inputLine);
			}	
			netout.println("get "+firstinfo.getId()); // why a 2nd time?
			while((inputLine=netin.readLine()).compareTo("get end") != 0) {
				System.out.println(inputLine);
			}


			System.out.println(inputLine);
			//sketchTree = new JTree(root); // is this right?
			//JScrollPane treeView = new JScrollPane(sketchTree);
//			sketchTree.removeAll();
//			sketchTree.add(root);
			// expand all the rows
			for (int i = 0; i < sketchTree.getRowCount(); i++) {
				sketchTree.expandRow(i);
			sketchTree.updateUI();
			}
			sketchTree.updateUI();
		} catch(IOException ioe) {
			System.err.println("Transfer error");
		}
	}
    }

    public SketchGUI(String host, int _listingPort, int _sketchPort, 
			boolean _isCam) {
	super();
	this.host = host;
	this.listingPort = _listingPort;
	this.sketchPort = _sketchPort;
	this.isCam = _isCam;
	//this.port = port;

	if(isCam)
		root = new DefaultMutableTreeNode("camspace");
	else root = new DefaultMutableTreeNode("worldspace");

	// network setup
	try {
		System.out.println("Trying to open socket...");
		listingSocket = new Socket(host,listingPort);
		netout = new PrintWriter(listingSocket.getOutputStream(), true);
  		netin = new BufferedReader(new InputStreamReader(
					listingSocket.getInputStream()));
	} catch (UnknownHostException e) {
		System.err.println("Don't know about host:"+host);
		System.exit(1);
	} catch (IOException e) {
		System.err.println("Couldn't get I/O for "
				+ "the connection to:" + host + ".");
		System.exit(1);
	}

	init();
    }

	

    public void init() {
	enableEvents(AWTEvent.FOCUS_EVENT_MASK);// want to receive FocusEvents

	int strutsize=10;
	int sepsize=5;
	getContentPane().setLayout(new BorderLayout());
	getContentPane().add(Box.createVerticalStrut(strutsize),BorderLayout.NORTH);
	getContentPane().add(Box.createHorizontalStrut(strutsize),BorderLayout.WEST);
	getContentPane().add(Box.createHorizontalStrut(strutsize),BorderLayout.EAST);
		
	setTitle("TekkotsuMon: Sketch/Shape Listing");
	sketchPanel=new SketchPanel(this, new TCPVisionListener(host, sketchPort), 
			isCam);
	sketchPanel.setMinimumSize(new Dimension(VisionListener.DEFAULT_WIDTH/2, VisionListener.DEFAULT_HEIGHT/2));
	sketchPanel.setPreferredSize(new Dimension(VisionListener.DEFAULT_WIDTH*2, VisionListener.DEFAULT_HEIGHT*2));
	sketchPanel.setLockAspectRatio(true);
	

	//getContentPane().add(sketch,BorderLayout.NORTH);

	// stuff specific to putting SketchPanel in new frame
	if (isCam)
		sketchFrame = new JFrame("Cam Sketch/Shape Frame");
	else sketchFrame = new JFrame("World Sketch/Shape Frame");
	sketchFrame.getContentPane().add(sketchPanel);
	sketchFrame.pack();
	sketchFrame.show();

	{

	    Box tmp1 = Box.createHorizontalBox();
	    tmp1.add(Box.createHorizontalStrut(strutsize));
	    {
		Box tmp2 = Box.createVerticalBox();

		tmp2.add(Box.createVerticalStrut(strutsize));

		{
		    Box tmp3 = Box.createHorizontalBox();
		    tmp3.add(status=new JLabel(state));
		    tmp3.add(Box.createHorizontalGlue());

		    tmp3.add(Box.createHorizontalStrut(strutsize));
		
		    refreshBut = new JButton("Refresh/Scale to Image");
		    refreshBut.setAlignmentX(0.5f);
		    refreshBut.addActionListener(this);
		    refreshBut.setActionCommand("refresh");
		    refreshBut.setEnabled(true);
		    refreshBut.setToolTipText("Refreshes the displayed sketch;");
		    tmp3.add(refreshBut);

		    tmp3.add(Box.createHorizontalStrut(strutsize));
		    
		    saveImageBut = new JButton("Save Image");
		    saveImageBut.setAlignmentX(0.5f);
		    saveImageBut.addActionListener(this);
		    saveImageBut.setActionCommand("saveimg");
		    saveImageBut.setEnabled(true);
		    saveImageBut.setToolTipText("Saves sketch to a file - use .jpg or .png extension to choose format;");
		    tmp3.add(saveImageBut);
			tmp3.add(Box.createHorizontalStrut(strutsize));


			refreshListBut = new JButton("Refresh Listing");
			refreshListBut.setAlignmentX(0.5f);
			refreshListBut.addActionListener(this);
			refreshListBut.setActionCommand("refreshlist");
			refreshListBut.setEnabled(true);
			refreshListBut.setToolTipText("Refreshes the sketch listing;");
			tmp3.add(refreshListBut);
		    tmp2.add(tmp3, BorderLayout.CENTER);
		}

		tmp2.add(Box.createVerticalStrut(strutsize));
		// Sketch Tree:
		sketchTree = new JTree(new DefaultTreeModel(initSketchTree(host, listingPort)));
		tmp2.add(new JScrollPane(sketchTree));
		// set up sketch node selection
		sketchTree.getSelectionModel().setSelectionMode
		            (TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
		//Listen for when the selection changes.
	    sketchTree.addTreeSelectionListener(this);
		sketchTree.setCellRenderer(new SketchTreeRenderer());

//		JFrame sketchFrame = new JFrame("Sketches");
//		sketchFrame.setSize(200,400);
//		sketchFrame.getContentPane().add(new JScrollPane(sketchTree));
//		JScrollPane sketchPane = new JScrollPane(sketchTree);
//		sketchPane.setSize(200,100);
//		tmp2.add(sketchPane);
		tmp2.add(Box.createVerticalStrut(strutsize));
		tmp2.add(new JSeparator());
		tmp2.add(Box.createVerticalStrut(strutsize-sepsize));
		{
		    Box tmp4 = Box.createHorizontalBox();
		    tmp4.add(status=new JLabel(state));
		    tmp4.add(Box.createHorizontalGlue());
		    tmp2.add(tmp4);
		}
		tmp2.add(Box.createVerticalStrut(strutsize));
		tmp1.add(tmp2);
	    }
	    tmp1.add(Box.createHorizontalStrut(strutsize));
	    getContentPane().add(tmp1,BorderLayout.CENTER);
	}
	pack();
	
	String name="SketchGUI"+".location";
	setLocation(prefs.getInt(name+".x",50),prefs.getInt(name+".y",50));

	// trigger some beginning events
//	actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "refreshlist"));
    }

    public TreeNode initSketchTree(String host, int port) {

	// Just for demonstration:
	DefaultMutableTreeNode cam = new DefaultMutableTreeNode("hit refresh");
	root.insert(cam,0);

	return root;
    }

	public void sortTree(DefaultMutableTreeNode curNode) {
		// set up comparator
		Comparator comp =
			new Comparator() {
				public int compare(Object o1, Object o2) {
					return compare((DefaultMutableTreeNode) o1, (DefaultMutableTreeNode) o2);    
				}
				public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
					Integer i1 = new Integer(((VisualObjectInfo)n1.getUserObject()).id);
					Integer i2 = new Integer(((VisualObjectInfo)n2.getUserObject()).id);
					return i1.compareTo(i2);
				}
			};

		// sort the roots children
		Object[] objs = new Object[curNode.getChildCount()];
		Enumeration children = curNode.children();
		for (int i=0;children.hasMoreElements();i++) {
			DefaultMutableTreeNode child = (DefaultMutableTreeNode) children.nextElement();
			objs[i] = child;
		}

		Arrays.sort(objs, comp);
		curNode.removeAllChildren();

		// insert newly ordered children
		for (int i=0;i<objs.length;i++) {
			DefaultMutableTreeNode orderedNode = (DefaultMutableTreeNode) objs[i];
			curNode.add(orderedNode);
			if (!orderedNode.isLeaf()) {
				sortTree(orderedNode);
			}
		}
	}

	// gets called when a Sketch selection is clicked
	public void valueChanged(TreeSelectionEvent e) {
		Graphics2D tempgraphics = sketchPanel._image.createGraphics();
		tempgraphics.setBackground(Color.GRAY);
		tempgraphics.clearRect(0,0,176,144);

		Graphics2D g = sketchPanel._image.createGraphics(); 

		TreePath[] paths = sketchTree.getSelectionPaths();
		if (paths == null) return;
		for (int path_i = 0; path_i < paths.length; path_i++) {
			DefaultMutableTreeNode node 
				=(DefaultMutableTreeNode)(paths[path_i].getLastPathComponent());

			if (node == root) continue;	
			if (node == null) return;
	
			VisualObjectInfo vinfo = (VisualObjectInfo)(node.getUserObject());
			System.out.println(vinfo.toString());
			if (!node.isRoot()) {
				System.out.println("id clicked:"+vinfo.id);
				netout.println("get "+vinfo.id);
				try {
					String inputLine;
					while((inputLine=netin.readLine()).compareTo("get end") != 0) {
						System.out.println(inputLine);
					}
				} catch (IOException ioe) {
					System.err.println("Transfer error");
				}
			} else {
				//displayURL(helpURL); 
			}
		}
		renderSelectedInTree(g);
	}

	// called when the window receives focus
	public void processFocusEvent(FocusEvent e) {
		System.out.println("received focus");
		repaint(); // keeps window from getting overwritten; bit of a hack
	}

	// renders all the currently selected elements in the tree
	public void renderSelectedInTree(Graphics2D g) {
		g = sketchPanel._image.createGraphics(); 
		TreePath[] paths = sketchTree.getSelectionPaths();
		if (paths == null) return;
		for (int path_i = 0; path_i < paths.length; path_i++) {
			DefaultMutableTreeNode node 
				=(DefaultMutableTreeNode)(paths[path_i].getLastPathComponent());

			if (node == root) continue;	
			if (node == null) return;

			VisualObjectInfo vinfo = (VisualObjectInfo)(node.getUserObject());
			int cval = vinfo.getColor();
			IndexColorModel cmodel = sketchPanel._listener.getColorModel();
			int rgb = cmodel.getRGB(cval);
			Color color = new Color(cmodel.getRGB(cval));
			g.setColor(new Color(cmodel.getRGB(vinfo.getColor())));

			g.setTransform(sketchPanel.resultAtrans);
			vinfo.renderTo(g);
		}
		sketchPanel.repaint();
		//repaint(); // repaints this frame
		//paintAll(); // repaints everything in this frame
	}

	private class SketchTreeRenderer extends DefaultTreeCellRenderer {
		public SketchTreeRenderer(/*Icon icon*/) {
//			tutorialIcon = icon;
		}

		public Component getTreeCellRendererComponent(
				JTree tree,
				Object value,
				boolean sel,
				boolean expanded,
				boolean leaf,
				int row,
				boolean hasFocus) {
			super.getTreeCellRendererComponent(
					tree, value, sel,
					expanded, leaf, row,
					hasFocus);
			try {
			VisualObjectInfo vinfo = (VisualObjectInfo)(((DefaultMutableTreeNode)value).getUserObject());
			
			setIcon(vinfo.getIcon());
			setToolTipText(vinfo.toString());
			} catch (ClassCastException e) {}

			return this;
		}
	}
}
