//-*-c++-*-
//This class is ported from Carnegie Mellon's 2001 Robosoccer entry, and falls under their license:
/*=========================================================================
    CMPack'02 Source Code Release for OPEN-R SDK v1.0
    Copyright (C) 2002 Multirobot Lab [Project Head: Manuela Veloso]
    School of Computer Science, Carnegie Mellon University
  -------------------------------------------------------------------------
    This software is distributed under the GNU General Public License,
    version 2.  If you do not have a copy of this licence, visit
    www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
    Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
    in the hope that it will be useful, but WITHOUT ANY WARRANTY,
    including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -------------------------------------------------------------------------
    Additionally licensed to Sony Corporation under the following terms:

    This software is provided by the copyright holders AS IS and any
    express or implied warranties, including, but not limited to, the
    implied warranties of merchantability and fitness for a particular
    purpose are disclaimed.  In no event shall authors be liable for
    any direct, indirect, incidental, special, exemplary, or consequential
    damages (including, but not limited to, procurement of substitute
    goods or services; loss of use, data, or profits; or business
    interruption) however caused and on any theory of liability, whether
    in contract, strict liability, or tort (including negligence or
    otherwise) arising in any way out of the use of this software, even if
    advised of the possibility of such damage.
  =========================================================================
*/
#ifndef __GVECTOR_GEOMETRY_H__
#define __GVECTOR_GEOMETRY_H__

#include "gvector.h"

typedef GVector::vector3d<double> vector3d;
typedef vector3d point3d;

typedef GVector::vector2d<double> vector2d;
typedef vector2d point2d;

typedef GVector::vector3d<float> vector3f;
typedef vector3f point3f;

typedef GVector::vector2d<float> vector2f;
typedef vector2f point2f;

/*! @file
 * @brief typedefs commonly used GVector's to vector3d, vector2d, vector3f, and vector2f
 * @author CMU RoboSoccer 2001-2002 (Creator)
 * 
 * @verbinclude CMPack_license.txt
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_1 $
 * $Revision: 1.3 $
 * $State: Rel $
 * $Date: 2003/09/25 15:27:22 $
 */

#endif
// __GVECTOR_GEOMETRY_H__
