#include "EventTranslator.h"
#include "Events/LocomotionEvent.h"
#include "Events/VisionObjectEvent.h"
#include "Events/TextMsgEvent.h"
#include "Events/EventRouter.h"
#include "Shared/debuget.h"
#include <iostream>

bool
EventTranslator::trapEvent(const EventBase& event) {
	enqueue(event,queue);
	return true;
}

void
EventTranslator::enqueue(const EventBase& event, Queue_t * q) {
	unsigned int len=event.getBinSize();
	TypeID_t type;
	if(dynamic_cast<const LocomotionEvent*>(&event)!=NULL) {
		type=LocomotionEvent_ID;
	} else if(dynamic_cast<const VisionObjectEvent*>(&event)!=NULL) {
		type=VisionObjectEvent_ID;
	} else if(dynamic_cast<const TextMsgEvent*>(&event)!=NULL) {
		type=TextMsgEvent_ID;
	} else {
		ASSERT(dynamic_cast<const EventBase*>(&event)!=NULL,"stupid OS");
		type=EventBase_ID;
	}
	void* buf=q->reserve(sizeof(TypeID_t)+len);
	if(buf==NULL) {
		ASSERT(false,"Queue overflow "<<type<<' '<<len);
	} else {
		*reinterpret_cast<TypeID_t*>(buf)=type;
		reinterpret_cast<char*>(buf)+=sizeof(TypeID_t);
		unsigned int err=event.SaveBuffer(reinterpret_cast<char*>(buf),len);
		ASSERT(err!=0,"bad save");
	}
	q->done();
}
	
void
EventTranslator::translateEvents() {
	unsigned int i;
	for(i=0; i<queue->size(); i++)
		sendEvent(queue->data(i),queue->size(i));
	while(!queue->clear(i)) //needed so if another was added while we were processing last one we will get it
		sendEvent(queue->data(i++),queue->size(i));
}

void
EventTranslator::sendEvent(const void * entry, unsigned int size) {
	TypeID_t type=*reinterpret_cast<const TypeID_t*>(entry);
	const char* buf=reinterpret_cast<const char*>(entry)+sizeof(TypeID_t);
	size-=sizeof(TypeID_t);
	switch(type) {
	case LocomotionEvent_ID: {
		LocomotionEvent * loco=new LocomotionEvent;
		unsigned int err=loco->LoadBuffer(buf,size);
		ASSERT(err!=0,"bad load");
		erouter->postEvent(loco);
	} break;
	case VisionObjectEvent_ID: {
		VisionObjectEvent * vision=new VisionObjectEvent;
		unsigned int err=vision->LoadBuffer(buf,size);
		ASSERT(err!=0,"bad load");
		erouter->postEvent(vision);
	} break;
	case TextMsgEvent_ID: {
		TextMsgEvent * text=new TextMsgEvent;
		unsigned int err=text->LoadBuffer(buf,size);
		ASSERT(err!=0,"bad load");
		erouter->postEvent(text);
	} break;
	case EventBase_ID: {
		EventBase * event=new EventBase;
		unsigned int err=event->LoadBuffer(buf,size);
		ASSERT(err!=0,"bad load");
		erouter->postEvent(event);
	} break;
	}
}


/*! @file
 * @brief Implements EventTranslator, which receives events from EventRouters in non-Main processes and adds them into a SharedQueue for Main to pick up
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_1 $
 * $Revision: 1.7 $
 * $State: Exp $
 * $Date: 2004/10/14 23:02:35 $
 */

