//-*-c++-*-
#ifndef INCLUDED_ButtonEvent_h_
#define INCLUDED_ButtonEvent_h_

#include "EventBase.h"

//! redefines getName and getDescription to use the button names instead of numerical source IDs (doesn't define any new data members - magnitude is used for pressure sensitive buttons)
class ButtonEvent : public EventBase {
public:
	/*! @name Constructors/Destructors */
	//! constructor
	/*! @see EventRouter::postEvent() */
	ButtonEvent() : EventBase() {}
	ButtonEvent(unsigned int sid, EventTypeID_t tid, unsigned int dur, float mag) : EventBase(buttonEGID,sid,tid) { setDuration(dur); setMagnitude(mag); }
	virtual ~ButtonEvent() {} //!< destructor
	//@}
	
	virtual std::string getDescription(bool showTypeSpecific=true, unsigned int verbosity=0) const; 

	//! Useful for serializing events to send between processes
	/*! @name LoadSave interface */
	virtual unsigned int getBinSize() const;
	virtual unsigned int LoadBuffer(const char buf[], unsigned int len);
	virtual unsigned int SaveBuffer(char buf[], unsigned int len) const;
	//@}
protected:
	virtual void genName();
};

/*! @file
 * @brief Describes ButtonEvent, redefines getName and getDescription to use the button names instead of numerical source IDs
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_1 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2004/09/16 20:39:53 $
 */

#endif
