#include "ButtonEvent.h"
#include <sstream>

std::string
ButtonEvent::getDescription(bool /*showTypeSpecific=true*/, unsigned int verbosity/*=0*/) const {
	std::ostringstream logdata;
	logdata << getName();
	char hexstring[30];
	snprintf(hexstring,sizeof(hexstring),"0x%x",getSourceID());
	logdata << '\t' << hexstring;
	switch(getTypeID()) {
	case EventBase::activateETID:
		logdata << "\tA"; break;
	case EventBase::statusETID:
		logdata << "\tS"; break;
	case EventBase::deactivateETID:
		logdata << "\tD"; break;
	case EventBase::numETIDs:
		logdata << "\tU"; break;  //UNKNOWN TYPE
	}
	if(verbosity>=1)
		logdata << '\t' << getDuration() << '\t' << getTimeStamp();
	if(verbosity>=2)
		logdata << '\t' << getMagnitude();
	return logdata.str();
}

unsigned int
ButtonEvent::getBinSize() const {
	unsigned int used=0;
	used+=creatorSize("ButtonEvent");
	used+=EventBase::getBinSize();
	return used;
}

unsigned int
ButtonEvent::LoadBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used=0;
	if(0==(used=checkCreator("ButtonEvent",buf,len,true))) return 0;
	len-=used; buf+=used;
	if(0==(used=EventBase::LoadBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	return origlen-len;	
}

unsigned int
ButtonEvent::SaveBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used=0;
	if(0==(used=saveCreator("ButtonEvent",buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=EventBase::SaveBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	return origlen-len;
}

void
ButtonEvent::genName() {
	if(!nameisgen)
		return;
	if(genID<numEGIDs) {
		stim_id=std::string("Evt_");
		stim_id+=EventGeneratorNames[genID];
	} else {
		stim_id=std::string("Evt_InvalidGen");
		stim_id+=genID; 
	}
	stim_id+="::";
	char tmp[16];
	snprintf(tmp,16,"0x%x",sourceID);
	stim_id+=tmp;
}


/*! @file
 * @brief 
 * @author YOURNAMEHERE (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_1 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2004/09/16 20:39:53 $
 */

