//-*-c++-*-
#ifndef INCLUDED_TimeOutTrans_h_
#define INCLUDED_TimeOutTrans_h_

#include "Behaviors/Transition.h"
#include "Events/EventRouter.h"

//! causes a transition after a specified amount of time has passed
class TimeOutTrans : public Transition {
public:
  //! constructor, specify delay in milliseconds
  TimeOutTrans(StateNode* destination, unsigned int delay) : Transition("TimeOutTrans",destination), d(delay) {}

  //! constructor, specify delay in milliseconds
  TimeOutTrans(const std::string& name, StateNode* destination, unsigned int delay) : Transition("TimeOutTrans",name,destination), d(delay) {}

  //!starts timer
  virtual void DoStart() {
    Transition::DoStart();
    resetTimer(); 
  }

  //!stops timer
  virtual void DoStop() { erouter->removeListener(this); Transition::DoStop(); }
  
  //!resets timer
  void resetTimer() {
    // std::cout << "Reset @ " << get_time() << " stop @ " << get_time()+d << ' ' << this << std::endl;
    erouter->addTimer(this,0,d,false);
  }

  //!if we receive the timer event, fire()
  virtual void processEvent(const EventBase&) {
    // std::cout << "Timeout @ " << get_time() << " from " << event.getName() << ' ' << this << std::endl;
    fire();
  }

protected:
  //! constructor, specify delay in milliseconds
  TimeOutTrans(const std::string& classname, const std::string& instancename, StateNode* destination, unsigned int delay) : Transition(classname,instancename,destination), d(delay) {}

  //!amount to delay (in milliseconds) before transition
  unsigned int d;
};

/*! @file
 * @brief Defines TimeOutTrans, which causes a transition after a specified amount of time has passed
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_1 $
 * $Revision: 1.14 $
 * $State: Exp $
 * $Date: 2004/11/15 22:46:19 $
 */

#endif
