//-*-c++-*-
#ifndef INCLUDED_NullTrans_h_
#define INCLUDED_NullTrans_h_

#include "Behaviors/Transition.h"
#include "Events/EventRouter.h"

//! a transition that occurs (via a 0 msec Timer event) as soon as the source node finishes starting up
class NullTrans : public Transition {
public:
  //! constructor
  NullTrans(StateNode* destination) : Transition("NullTrans",destination) {}
	
  //! constructor
  NullTrans(const std::string& name, StateNode* destination) : Transition("NullTrans",name,destination) {}
	
  //!starts 0 msec timer, so transition will occur very soon
  virtual void DoStart() {
    Transition::DoStart();
    erouter->addTimer(this,0,0,false);
  }

  //!stops timer
  virtual void DoStop() { erouter->removeListener(this); Transition::DoStop(); }

  //!when timer event is received, fire() the transition
  virtual void processEvent(const EventBase&) { fire(); }
};

/*! @file
 * @brief Defines NullTrans, which causes a transition as soon as the source node finishes starting up
 * @author dst (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_1 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2004/11/15 22:46:19 $
 */

#endif
