//-*-c++-*-
#ifndef INCLUDED_EventTrans_h_
#define INCLUDED_EventTrans_h_

#include "Behaviors/Transition.h"
#include "Events/EventRouter.h"

//! causes a transition when the specified event is received

class EventTrans : public Transition {
private:
  int argcount;
  EventBase::EventGeneratorID_t egid;
  unsigned int esid;
  EventBase::EventTypeID_t etid;

public:
  EventTrans(StateNode* destination, EventBase::EventGeneratorID_t gid)
		: Transition("EventTrans",destination), argcount(1), egid(gid), esid(0), etid(EventBase::statusETID)
	{}

  EventTrans(StateNode* destination, EventBase::EventGeneratorID_t gid, unsigned int sid)
		: Transition("EventTrans",destination), argcount(2), egid(gid), esid(sid), etid(EventBase::statusETID)
	{}

  EventTrans(StateNode* destination, EventBase::EventGeneratorID_t gid, unsigned int sid, EventBase::EventTypeID_t tid)
		: Transition("EventTrans",destination), argcount(3), egid(gid), esid(sid), etid(tid)
	{}

  EventTrans(const std::string& name, StateNode* destination, EventBase::EventGeneratorID_t gid)
		: Transition("EventTrans",name,destination), argcount(1), egid(gid), esid(0), etid(EventBase::statusETID)
	{}

  EventTrans(const std::string& name, StateNode* destination, EventBase::EventGeneratorID_t gid, unsigned int sid)
		: Transition("EventTrans",name,destination), argcount(2), egid(gid), esid(sid), etid(EventBase::statusETID)
	{}

  EventTrans(const std::string& name, StateNode* destination, EventBase::EventGeneratorID_t gid, unsigned int sid, EventBase::EventTypeID_t tid)
		: Transition("EventTrans",name,destination), argcount(3), egid(gid), esid(sid), etid(tid)
	{}

  //! starts listening
  virtual void DoStart() {
    Transition::DoStart();
    switch (argcount) {
    case 1: erouter->addListener(this,egid); break;
    case 2: erouter->addListener(this,egid,esid); break;
    case 3: erouter->addListener(this,egid,esid,etid);
    };
  }

  //! stops listening
  virtual void DoStop() {
    erouter->removeListener(this);
    Transition::DoStop();
  }

  //! fire the transition if an event is seen
  virtual void processEvent(const EventBase&) { fire(); }

};

/*! @file
 * @brief Defines EventTrans, which causes a transition if an event of the specified type occurs
 * @author dst (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_1 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2004/11/15 22:46:19 $
 */

#endif
