//-*-c++-*-
#ifndef INCLUDED_HeadPointerNode_h_
#define INCLUDED_HeadPointerNode_h_

#include "Behaviors/StateNode.h"
#include "Events/EventRouter.h"
#include "Motion/HeadPointerMC.h"

//! A simple StateNode that executes a LedMC motion command and throws a status event upon completion
class HeadPointerNode : public StateNode {
protected:
  SharedObject<HeadPointerMC> head_mc;    //!< MotionCommand used by this node
  MotionManager::MC_ID head_id;  //!< id number for the MotionCommand

public:
  //! constructor
  HeadPointerNode(std::string nodename="HeadPointerNode") : 
    StateNode("HeadPointerNode",nodename), head_mc(), head_id(MotionManager::invalid_MC_ID) {}

  //! activate the node
  virtual void DoStart() {
    head_id = motman->addPersistentMotion(head_mc);
    erouter->addListener(this,EventBase::motmanEGID,head_id,EventBase::statusETID);
    StateNode::DoStart();  // don't activate transitions until our listener has been added
  }

  //! deactivate the node
  virtual void DoStop() {
    motman->removeMotion(head_id);
    head_id = MotionManager::invalid_MC_ID;
    erouter->removeListener(this);
    StateNode::DoStop();
  }

  //! receive motmanEGID status event and throw stateMachineEGID status event
  virtual void processEvent(const EventBase&) {
		erouter->postEvent(EventBase::stateMachineEGID,reinterpret_cast<unsigned int>(this),EventBase::statusETID,0,getName(),1);
  }

  //! reveal the MotionCommand
  SharedObject<HeadPointerMC>& getMC() { return head_mc; }

  //! reveal the MC_ID
  MotionManager::MC_ID& getMC_ID() { return head_id; }

protected:
  //! constructor
  HeadPointerNode(std::string &classname, std::string &nodename) : 
    StateNode(classname,nodename), head_mc(), head_id(MotionManager::invalid_MC_ID) {}


};

/*! @file
 * @brief Defines HeadPointerNode, a simple StateNode that runs a HeadPointerMC motion command and throws a status event upon completion
 * @author dst (Creator)
 *
 * $Author: dst $
 * $Name: tekkotsu-2_2_1 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2004/11/17 01:31:06 $
 */

#endif
