//-*-c++-*-
#ifndef INCLUDED_MicrophoneServer_h_
#define INCLUDED_MicrophoneServer_h_

#include "Events/EventBase.h"
#include "Behaviors/BehaviorBase.h"

//! Streams audio from the microphone over the network
class MicrophoneServer : public BehaviorBase {
	public:
		static MicrophoneServer* GetInstance();
		virtual ~MicrophoneServer();
		
		virtual void DoStart();
		virtual void DoStop();
		virtual void processEvent(const EventBase& event);
		
		static bool SetMicrophoneUnidirectional(bool unidirectional);
		static bool SetMicrophoneAlcEnabled(bool enabled);
		
	private:
		static const unsigned int SEND_BUFFER_SIZE = 2048 + 16;
	
		MicrophoneServer();
		MicrophoneServer(const MicrophoneServer& rhs);
		MicrophoneServer& operator=(const MicrophoneServer& rhs);
		static MicrophoneServer* instance;
		
		unsigned int GetResampledFrameSize(
			unsigned int samplesSize,
			unsigned int newSampleRate,
			unsigned int newSampleBits,
			bool newStereo);
		
		unsigned int ResampleFrame(
			const char* samples,
			unsigned int samplesSize,
			unsigned int& newSampleRate,
			unsigned int& newSampleBits,
			bool& newStereo,
			void* newSamples,
			unsigned int newSamplesSize);
		
		static const char* const MIC_LOCATOR;
		
		class Socket *socket;
		
		//! writes @a value to @a dst and advances @a dst
		template<class T>
		inline static void encode(char **dst, const T& value) {
			memcpy(*dst, &value, sizeof(T));
			(*dst) += sizeof(T);
		}
		
		//! writes @a length bytes from @a src to @a dst
		template<class T>
		inline static void encode(char **dst, const T * src, int num) {
			memcpy(*dst, src, num*sizeof(T));
			(*dst) += num*sizeof(T);
		}
};
#endif
