#include "StareAtBallBehavior.h"
#include "Events/EventRouter.h"
#include "Events/VisionObjectEvent.h"
#include "Shared/WorldState.h"
#include "Motion/HeadPointerMC.h"
#include "Shared/ProjectInterface.h"

//! Converts degrees to radians
inline double DtoR(double deg) { return (deg/180.0*M_PI); }

void StareAtBallBehavior::DoStart() {
	BehaviorBase::DoStart();
	headpointer_id = motman->addPersistentMotion(SharedObject<HeadPointerMC>());
	erouter->addListener(this,EventBase::visObjEGID,ProjectInterface::visPinkBallSID);
}

void StareAtBallBehavior::DoStop() {
	erouter->removeListener(this);
	motman->removeMotion(headpointer_id);
	BehaviorBase::DoStop();
}

//this could be cleaned up event-wise (only use a timer when out of view)
void StareAtBallBehavior::processEvent(const EventBase& event) {
	/*if(event.getSourceID()==ProjectInterface::visBlueBallSID) {
		cout << "BLUE" << endl;
		} else if(event.getSourceID()==ProjectInterface::visPinkBallSID) {
		cout << "PINK" << endl;
		}
	*/

	static float horiz=0,vert=0;
	if(event.getGeneratorID()==EventBase::visObjEGID && event.getTypeID()==EventBase::statusETID) {
		horiz=static_cast<const VisionObjectEvent*>(&event)->getCenterX();
		vert=static_cast<const VisionObjectEvent*>(&event)->getCenterY();
	}

	//cout << horiz << ' ' << vert << endl;

	double tilt=state->outputs[HeadOffset+TiltOffset]-vert*M_PI/7;
	double pan=state->outputs[HeadOffset+PanOffset]-horiz*M_PI/6;
	if(tilt<DtoR(-70))
		tilt=DtoR(-70);
	if(tilt>DtoR(40))
		tilt=DtoR(40);
	if(pan>DtoR(80))
		pan=DtoR(80);
	if(pan<DtoR(-80))
		pan=DtoR(-80);
	HeadPointerMC * headpointer= (HeadPointerMC*)motman->checkoutMotion(headpointer_id);
	headpointer->setJoints(tilt,pan,0);
	motman->checkinMotion(headpointer_id);
}
			
/*! @file
 * @brief Implements StareAtBallBehavior, which points the head at the ball
 * @author tss (Creator)
 */


