//-*-c++-*-
#ifndef INCLUDED_ExploreMachine_h_
#define INCLUDED_ExploreMachine_h_

#include "Behaviors/StateNode.h"
#include "Behaviors/Nodes/WalkNode.h"
#include "Behaviors/Transitions/SmoothCompareTrans.h"
#include <stdlib.h>
#include "Shared/ERS210Info.h"
#include "Shared/ERS220Info.h"
#include "Shared/ERS7Info.h"
#include "Wireless/Socket.h"

//! A state machine for exploring an environment (or searching for an object)
class ExploreMachine : public StateNode {
public:
	//!constructor
	ExploreMachine()
		: StateNode("ExploreMachine","ExploreMachine"), start(NULL), turn(NULL), walkid(MotionManager::invalid_MC_ID)
	{
		setRetain(false);
	}

	//!constructor
	ExploreMachine(const std::string& nm, StateNode* p=NULL)
		: StateNode("ExploreMachine",nm,p), start(NULL), turn(NULL), walkid(MotionManager::invalid_MC_ID)
	{
		setRetain(false);
	}

	virtual void setup() {
		//cout << "Explore SETUP " << issetup << "...";
		unsigned int IRDistOffset;
		if(state->robotDesign&WorldState::ERS210Mask)
			IRDistOffset=ERS210Info::IRDistOffset;
		else if(state->robotDesign&WorldState::ERS220Mask)
			IRDistOffset=ERS220Info::IRDistOffset;
		else if(state->robotDesign&WorldState::ERS7Mask)
			IRDistOffset=ERS7Info::NearIRDistOffset;
		else {
			serr->printf("ExploreMachine: Unsupported model!\n");
			return;
		}

		SharedObject<WalkMC> walk;
		walkid=motman->addPersistentMotion(walk);
		WalkNode * move=NULL;
		start=addNode(turn=new WalkNode(0,0,0.5f,this));
		turn->setName(getName()+"::turn");
		addNode(move=new WalkNode(150,0,0,this));
		move->setName(getName()+"::move");
		turn->addTransition(new TimeOutTrans(move,2000));
		move->addTransition(new SmoothCompareTrans<float>(turn,&state->sensors[IRDistOffset],CompareTrans<float>::LT,350,EventBase(EventBase::sensorEGID,SensorSourceID::UpdatedSID,EventBase::statusETID),.7));
		turn->setWalkID(walkid);
		move->setWalkID(walkid);
		StateNode::setup();
		
		//cout << issetup << endl;
	}

	virtual void DoStart() {
		StateNode::DoStart();
		start->DoStart();
		//erouter->addListener(this,EventBase::sensorEGID,SensorSourceID::UpdatedSID);
		erouter->addListener(this,EventBase::stateMachineEGID,(unsigned int)turn);
	}

	virtual void DoStop() {
		erouter->removeListener(this);
		StateNode::DoStop();
	}

	virtual void teardown() {
		//cout << "Explore TEARDOWN " << issetup << "...";
		motman->removeMotion(walkid);
		StateNode::teardown();
		//cout << issetup << endl;
	}

	virtual void processEvent(const EventBase& /*e*/) {
		//sout->printf("IR: %g\n",state->sensors[IRDistOffset]);
		float vel=rand()/(float)RAND_MAX*2.0f-1;
		if(vel<0)
			vel-=.25;
		if(vel>0)
			vel+=.25;
		turn->setAVelocity(vel);
	}

protected:
	StateNode * start; //!< the node to begin within on DoStart() (turn)
	WalkNode * turn; //!< walk node to use when turning
	MotionManager::MC_ID walkid; //!< we want to share a walk between turning and walking nodes

private:
	ExploreMachine(const ExploreMachine&); //!< don't use
	ExploreMachine operator=(const ExploreMachine&); //!< don't use
};

/*! @file
 * @brief Describes ExploreMachine, a state machine for exploring an environment (or searching for an object)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_1 $
 * $Revision: 1.21 $
 * $State: Exp $
 * $Date: 2004/11/11 21:32:14 $
 */

#endif
