#include "ASCIIVisionBehavior.h"
#include "Events/FilterBankEvent.h"
#include "Vision/RawCameraGenerator.h"
#include "Wireless/Socket.h"

const char ASCIIVisionBehavior::charMap[ASCIIVisionBehavior::charMapSize] = {
	' ','.','\'','`','^','"',',',':',';','~','-','!','i','l','I','>','<','+','?',')',
	'1',']','|','/','t','f','j','r','n','u','v','c','z','x','Y','U','J','C','L','Q',
	'0','O','Z','X','m','w','q','p','d','b','k','h','a','o','*','#','M','W','&','8',
	'%','B','$','@'
};


void
ASCIIVisionBehavior::processEvent(const EventBase& e) {
	const FilterBankEvent& fbkevt=dynamic_cast<const FilterBankEvent&>(e);

	unsigned int layer = 1;

	char charimg[(fbkevt.getWidth(layer)+1)*fbkevt.getHeight(layer)+1];
	char * curchar=charimg;
	unsigned char * image = fbkevt.getImage(layer, RawCameraGenerator::CHAN_Y);
	for (unsigned int y = 0; y < fbkevt.getHeight(layer); y++) {
		unsigned char * row = image + (y * fbkevt.getStride(layer));
		for (unsigned int x = 0; x < fbkevt.getWidth(layer); x++) {
			unsigned char * pixel = row + (x * fbkevt.getIncrement(layer));
			*curchar++=charMap[(pixel[0]*charMapSize)/256];
		}
		*curchar++='\n';
	}
	*curchar='\0';

	sout->printf("\n\n%s",charimg);
}

