//-*-c++-*-
#ifndef INCLUDED_ProfilerCheckControl_h_
#define INCLUDED_ProfilerCheckControl_h_

#include "ControlBase.h"
#include "Shared/WorldState.h"

//! causes the WorldState::mainProfile and WorldState::motionProfile to display reports to #sout
class ProfilerCheckControl : public ControlBase {
public:
	//! Constructor
	ProfilerCheckControl() : ControlBase("Profiler Check","Reports time spent in all of the profiled sections in all processes") {}

	//! Prints a report to sout
	virtual ControlBase * activate(MotionManager::MC_ID, Socket *) {
		sout->printf("~~~ Main: ~~~\n%s",state->mainProfile.report().c_str());
		sout->printf("~~~ Motion: ~~~\n%s",state->motionProfile.report().c_str());
		return NULL;
	}
};

/*! @file
 * @brief Defines ProfilerCheckControl, which causes the WorldState::mainProfile and WorldState::motionProfile to display reports to #sout
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2_1 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2004/11/11 20:34:59 $
 */

#endif
