% note:  Unless you have a relatively fast computer, 
% using MATLAB to display video will likely result in a 
% frame rate lower than the 30Hz that the AIBO provides.
% You can log video at this rate, but updating the screen
% takes an extraodinarily long time.  Frames will likely 
% be missed


close all;
clear all;
clc;


time = 5;
show_video = true;

port = 10011;
height = 80;
width = 104;


global vis;
vis.obj = org.tekkotsu.mon.VisionListener('192.168.0.4',port);


vis.imdata=zeros(height,width);
vis.im=imagesc(vis.imdata);

% this prevents the video from flashing when 
% redrawing.  
set(gcf,'Renderer','zbuffer');


start = clock;
while (~vis.obj.hasData)
	if etime(clock,start) > 4
		'time out'
		return
	end
end
dummy = vis.obj.getData; 
frame = 0;


start_time = clock;
tic
while(etime(clock,start_time) < time)
	% this pause statement is necessary to allow 
	% MATLAB to recognize a change in state of 
	% the java object
	pause(0);
	if(vis.obj.hasData)
		frame = frame + 1;    
		
		data = vis.obj.getData;
		%  extract y,u,v channel data and reshape it from
		%  a pixel stream to a 2d image
		YUV(:,:,1)=reshape(data(1:3:length(data)),width,height)';
		YUV(:,:,2)=reshape(data(2:3:length(data)),width,height)';
		YUV(:,:,3)=reshape(data(2:3:length(data)),width,height)';
		
		%  make unsigned
		YUV=double(YUV)+(YUV<0)*256;
		
		%convert to rgb
		picture=min(1,max(yuv2rgb(YUV)/255,0));
		set(vis.im,'cdata',picture);
		
	end
	drawnow;
end
toc
frame

vis.obj.close;



