package org.tekkotsu.mon;

import javax.swing.JPanel;
import java.awt.image.BufferedImage;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class VisionPanel extends JPanel implements VisionUpdatedListener {
	BufferedImage _image;
	VisionListener _listener;
	boolean lockAspect=false;
	float tgtAspect=-1;

	public static void usage() {
		System.out.println("Usage: java VisionPanel host [port|raw|rle]");
		System.out.println("       if port is not specified, it defaults to:");
		System.out.println("       "+VisionListener.defRawPort+" for raw");
		System.out.println("       "+VisionListener.defRLEPort+" for RLE.");
		System.exit(2);
	}

	public static void main(String s[]) {
		int port=-1;
		if(s.length<2)
			usage();
		if(s[1].toUpperCase().compareTo("RLE")==0) {
			port=VisionListener.defRLEPort;
		} else if(s[1].toUpperCase().compareTo("RAW")==0) {
			port=VisionListener.defRawPort;
		} else {
			port=Integer.parseInt(s[1]);
		}

		JFrame frame=new JFrame("TekkotsuMon: Vision");
		frame.setBackground(Color.black);
		//frame.getContentPane().setLayout(new FlowLayout());
		frame.setSize(new Dimension(VisionListener.DEFAULT_WIDTH*2, VisionListener.DEFAULT_HEIGHT*2)); 
		VisionPanel vision=new VisionPanel(new VisionListener(s[0],port));
		frame.getContentPane().add(vision);
		frame.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) { System.exit(0); } });
		frame.show();
	}

	public void setConvertRGB(boolean b) { _listener.setConvertRGB(b); }
	public boolean getConvertRGB() { return _listener.getConvertRGB(); }

	protected VisionPanel(VisionListener listener) {
		_listener=listener;
		_listener.addListener(this);
		setBackground(Color.BLACK);
		setForeground(Color.WHITE);
		setOpaque(!lockAspect);
	}
	
	public VisionListener getListener() { return _listener; }
	
	public void close() {
		_listener.kill();
	}
	
	public void open() {
		_listener.startThread();
	}

	public void visionUpdated(VisionListener l) {
		repaint();
	}
	
	public void setLockAspectRatio(boolean b) {
		if(b!=lockAspect) {
			lockAspect=b;
			setOpaque(!lockAspect);
			repaint();
		}
	}
	
	public boolean getLockAspectRatio() { return lockAspect; }

	public void setAspectRatio(float asp) {
		if(asp<=0)
			tgtAspect=-1;
		else
			tgtAspect=asp;
		if(getLockAspectRatio())
			repaint();
	}
	
	public float getAspectRatio() { return tgtAspect; }

	public void setLockAspectRatio(boolean b, float asp) {
		setLockAspectRatio(b);
		setAspectRatio(asp);
	}
	
	public void paint(Graphics graphics) {
		_image=_listener.getImage();
		super.paint(graphics);
		Dimension sz=getSize();
		if(getLockAspectRatio()) {
			float curasp=sz.width/(float)sz.height;
			float tgtasp=getAspectRatio();
			if(tgtasp<0)
				tgtasp=_image.getWidth()/(float)_image.getHeight();
			if(curasp>tgtasp) {
				int width=(int)(sz.height*tgtasp);
				drawImage(graphics,_image, (sz.width-width)/2, 0, width, sz.height);
			} else if(curasp<tgtasp) {
				int height=(int)(sz.width/tgtasp);
				drawImage(graphics,_image, 0, (sz.height-height)/2, sz.width, height);
			} else {
				drawImage(graphics,_image, 0, 0, sz.width, sz.height);
			}
		} else
			drawImage(graphics,_image, 0, 0, sz.width, sz.height);
	}
	
	protected void drawImage(Graphics g, BufferedImage img, int x, int y, int w, int h) {
		if(img!=null)
			g.drawImage(img,x,y,w,h,null);
		else {
			g.setColor(getBackground());
			g.fillRect(x,y,w,h);
			FontMetrics tmp=g.getFontMetrics();
			String msg="No image";
			int strw=tmp.stringWidth(msg);
			int strh=tmp.getHeight();
			g.setColor(getForeground());
			g.drawString(msg,(getSize().width-strw)/2,(getSize().height-strh)/2+tmp.getAscent());
		}
	}
}
