#include "StartupBehavior.h"

#include "Behaviors/Controls/ControlBase.h"
#include "Behaviors/Controls/BehaviorSwitchControl.h"

#include "Behaviors/Demos/AutoGetupBehavior.h"
#include "Behaviors/Demos/BatteryMonitorBehavior.h"
#include "Behaviors/Demos/HeadLevelBehavior.h"
#include "Behaviors/Demos/ToggleHeadLightBehavior.h"
#include "Behaviors/Demos/HelloWorldBehavior.h"
#include "Behaviors/Demos/CrashTestBehavior.h"
#include "Behaviors/Demos/RelaxBehavior.h"
#include "Behaviors/Demos/WorldStateVelDaemon.h"
#include "Behaviors/Demos/CameraBehavior.h"

#include "Shared/WorldState.h"
#include "Shared/ERS210Info.h"

ControlBase*
StartupBehavior::SetupBackgroundBehaviors() {
	addItem(new ControlBase("Background Behaviors","Background daemons and monitors"));
	startSubMenu();
	{ 
		addItem((new BehaviorSwitchControl<AutoGetupBehavior>("AutoGetupBehavior",false))->start());
		addItem((new BehaviorSwitchControl<BatteryMonitorBehavior>("BatteryMonitorBehavior",false))->start());
		addItem(new BehaviorSwitchControl<HeadLevelBehavior>("HeadLevelBehavior",false));
		if(state->robotDesign & WorldState::ERS220Mask)
			addItem(new BehaviorSwitchControl<ToggleHeadLightBehavior>("ToggleHeadLightBehavior",false));
		addItem(new BehaviorSwitchControl<HelloWorldBehavior>("HelloWorldBehavior",false));
		addItem(new BehaviorSwitchControl<CrashTestBehavior>("CrashTestBehavior",false));
		addItem(new BehaviorSwitchControl<RelaxBehavior>("RelaxBehavior",false));
		addItem(new BehaviorSwitchControl<CameraBehavior>("CameraBehavior",false));
		addItem((new BehaviorSwitchControl<WorldStateVelDaemon>("WorldStateVelDaemon",false))->start());
	}
	return endSubMenu();
}
