/*
 * almMain.h -- defines the main class for interfacing with the AIBO
 *   Local Map.
 *
 * Started 12-12-2002, tss
 */

#ifndef _ALM_MAIN_H_
#define _ALM_MAIN_H_

#include "almStructures.h"
#include "../WorldModel2.h"
// needed for afsPose structure.
#include "../FastSLAM/afsParticle.h"

// This class contains method declarations for interfacint with the AIBO
// Local Map. Don't tell anyone that this C++ code is really C in disguise.
// I know it sounds disgusting, but there's really no need for individual
// objects in this code. Besides, we can restrict enumerations and whatnot
// to the class namespace. Oh, leave me alone.
class ALM
{
// WorldModel2 has access to us to gather motion requests
friend class WorldModel2;

public:
  // This method initializes the static tables used to hold the map data.
  // Yes, you have to manually run an initializer. I apologize!
  static void init(void);

  // This method applies motion to the maps, updating them so that they
  // remain egocentric and so that uncertain regions are duly noted.
  // The parameters are the same as those applied to the motion commands.
  static void move(double dx, double dy, double da, unsigned int time);

  // This method registers a depth measurement in the local maps
  static void registerDepth(double depth, double tilt, double pan);
  // This method does the same, but it allows the user to specify kludges
  // that can give "better" performance in certain limited environments.
  // See the WM2Kludge namespace definition in WorldModel2.h for details.
  static void registerDepth(double depth, double tilt, double pan,
			    unsigned int kludges);

  // This method uses the ground plane assumption to fill the local maps
  // with information about the location of the ground based on the location
  // of the head and the image coming from the camera. Head and image
  // information are obtained from WorldState, etc.
  static void registerGround();

  // This method copies the information from the HM onto the global map
  // (or, more poetically, turns the HM into a rubber stamp).
  // You need to furnish it with the current pose information, which you
  // get from FastSLAM
  static void stampHM(afsPose &pose);

  // Dump depth map data selected by a dmPicker you implement (or just
  // instantiate) into the supplied iostream. Uses ASCII .mat file
  // "format", seperating row elements with tabs and rows with newlines.
  static void dumpDM(dmPicker &p, std::ostream &out);

  // Dump height map data selected by a hmPicker you implement (or just
  // instantiate) into the supplied iostream. Uses ASCII .mat file
  // "format", seperating row elements with tabs and rows with newlines.
  static void dumpHM(hmPicker &p, std::ostream &out);

  // What this thing does with all this information remains to be seen...

private:

  // This method clears the current map to simulate an empty room: the ground
  // will appear in the proper place in the spherical map with the rest empty;
  // the height map will be zeroed everywhere. Actually, in addition to other
  // administrativa, init just calls this function.
  static void nukeAndPaveCurrentMap(void);

#ifdef UNIT_TEST_ALM_MA
public:
#endif

  // This method generates motion requests for WorldModel2. It's the reason
  // WorldModel2 is our friend.
  static void genRequests(MRvector &requests);

  // These methods provide direct access to the local map data arrays. You
  // should use DM_CELL_COUNT and HM_CELL_COUNT to index these arrays.
  // These methods are PRIVATE and are intended only for use by WorldModel2
  // objects.
  // Whenever you want to access the DM or the HM arrays, you should always
  // call these routines before doing your manipulation. This is because 
  // double buffering is used here, and you may find yourself pointing at
  // an old buffer if you don't update your pointers.
  static dm_cell *getDM();
  static hm_cell *getHM();
};

#endif
