#ifndef _WALK_MOTION_MODEL_H_
#define _WALK_MOTION_MODEL_H_


#ifdef __cplusplus
extern "C" {
#endif

/* An ad-hoc motion model for the AIBO's walking motion as supplied by the
 * RoboSoccer team. dx, dy, and da are the velocities sent to the WalkMC
 * object and time is the duration of time (in milliseconds) that they
 * were executed. x, y, and theta describe the current position of the
 * AIBO and will be changed to reflect the AIBO's position after the move.
 * If you wish to compute relative changes in motion, simply point these
 * to variables you've set to 0. */
void WalkMotionModel(double *x, double *y, double *theta,
		     double dx, double dy, double da, unsigned int time);
#ifdef __cplusplus
}
#endif
#endif
