//-*-c++-*-
#ifndef INCLUDED_EvtRptBehavior_h_
#define INCLUDED_EvtRptBehavior_h_

#include "Behaviors/BehaviorBase.h"

//! A simple behavior to test event reports
class EvtRptBehavior : public BehaviorBase {
public:
	//!constructor
	EvtRptBehavior()
		: BehaviorBase()
	{}
	//!destructor
	virtual ~EvtRptBehavior() {}

	//! Subscribes to various events
	virtual void DoStart();

	//! Cancels event subscriptions
	virtual void DoStop();

	//! prints out data on subscribed events
	virtual void processEvent(const EventBase& event);
			
	virtual std::string getName() const { return "EvtRptBehavior"; }
	static std::string getClassDescription() { return "A simple behavior to test event reports to the console"; }
};

/*! @file
 * @brief Describes EvtRptBehavior, which couts information about events it sees
 * @author tss (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_1 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2003/12/14 00:23:54 $
 */

#endif
