import java.awt.image.BufferedImage;
import java.util.Vector;
import java.util.Date;

public abstract class VisionListener extends TCPListener {
    boolean updatedFlag;
    Date timestamp;
    
    Vector listeners = new Vector();
    void addListener(VisionUpdatedListener l) { listeners.add(l); }
    void removeListener(VisionUpdatedListener l) { listeners.remove(l); }
    void fireVisionUpdate() {
	updatedFlag=true;
	for(int i=0; i<listeners.size(); i++)
	    ((VisionUpdatedListener)listeners.get(i)).visionUpdated(this);
    }
    
    public abstract BufferedImage getImage();
    // BEGIN PGSS ADDITIONS
    public abstract void printRegionMap();
    public abstract void setUserPreferredVelocity(int userPreferredVelocity);
    // END PGSS ADDITIONS
    public Date getTimeStamp() { return timestamp; }
    
    public boolean hasData() {
	return updatedFlag;
    }
    
    public boolean isConnected() {
	return _isConnected;
    }
    
    public VisionListener() { super(); }
    public VisionListener(int port) { super(port); }
    public VisionListener(String host, int port) { super(host,port); }
}
