import java.net.ServerSocket;
import java.net.Socket;

public abstract class TCPListener extends Listener {
	abstract void connected(Socket socket);

	void runServer() {
		Thread me = Thread.currentThread();
		try { _serverSocket=new ServerSocket(_port); }
		catch (Exception ex) {
			System.out.println("port "+_port+": "+ex);
			return;
		}

		while (me == _listenerThread && !destroy) {
			try {
				_socket=_serverSocket.accept();
				connected(_socket);
			} catch (Exception ex) { }
		}
	}

	void runConnect() {
		int attempts=0;
		Thread me = Thread.currentThread();
		while (me==_listenerThread && !destroy) {
			if(attempts==0) {
				//				if(attempts!=0)
				//					System.err.println("");
				System.err.print("TCPListener port "+_port+" - Connecting..");
			}
			try {
				System.err.print(".");
				_socket=new Socket(_host,_port);
				System.err.println(" connected.");
				attempts=0;
				_isConnected=true;
			} catch (Exception ex) {}
			if(_isConnected) {
				connected(_socket);
				if(!destroy)
					System.err.println("TCPListener port "+_port+" - Disconnected, attempting to reestablish...");
			}
			attempts++;
			if(destroy) {
				System.err.println("TCPListener port "+_port+" - Connection closed.");
				break;
			}
			try {
				Thread.sleep(500);
			} catch (Exception ex) {}
		}
	}

	public void close() {
		_listenerThread=null;
		_isConnected=false;
		try { _socket.close(); } catch (Exception ex) { }
		if (_isServer)
			try { _serverSocket.close(); } catch (Exception ex) { }
	}

	public TCPListener() { super(); }
	public TCPListener(int port) { super(port); }
	public TCPListener(String host, int port) { super(host,port); }

	Socket _socket;
	ServerSocket _serverSocket;
}
