import java.awt.event.*;
import javax.swing.*;
import java.lang.String;
import java.util.LinkedList;
import java.awt.*;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Date;
import java.io.PrintWriter;
import java.io.FileOutputStream;

public class PGSSVisionGUI extends JFrame implements ActionListener, VisionUpdatedListener {
    VisionPanel vision;
    JCheckBox aspectBut;
    JButton freezeBut;
    JButton saveImageBut;
    JLabel status;
    JButton reconnectBut;
    float mspf=0;
    float mspfGamma=.9f;
    long lastFrameTime=0;
    boolean isRaw=false;
    boolean isRLE=false;
    boolean isPGSS=false;
    boolean connected=false;
    boolean isFreezeFrame=false;
    PGSSWalkGUI walkGUI=null;

    final static ImageIcon carrows = new ImageIcon("images/chasingarrows.png");
    ImageSequenceWriterThread imgWrite=null;
    String state="Connecting...";
    
    public class StatusUpdateThread extends Thread {
	PGSSVisionGUI gui;
	public StatusUpdateThread(PGSSVisionGUI gui) { super("StatusUpdate"); this.gui=gui; setDaemon(true);}
	public void run() {
	    VisionListener l=gui.vision.getListener();
	    while(true) {
		String status=gui.state;
		String recording=recordReport();
		String fps=fpsReport();
		if(fps.length()>0)
		    status+=" - "+fps;
		if(recording.length()>0)
		    status+="; "+recording;
		gui.status.setText(status);
		try {
		    sleep(100);
		} catch(Exception ex) {break;}
	    }
	}
	public String recordReport() {
	    if(gui.imgWrite!=null && (!gui.imgWrite.stopping || gui.imgWrite.isAlive())) {
		String ans;
		if(!gui.imgWrite.stopping) {
		    ans="Rec: ";
		    if(imgWrite.imgBufs.size()!=0)
			ans+="Free="+imgWrite.imgBufs.size();
		} else
		    ans="Writing";
		ans+=" Queue="+imgWrite.q.size();
		return ans;
	    } else
		return "";
	}
	public String fpsReport() {
	    if(connected) {
		int rnd=(int)(10000/gui.mspf);
		return rnd/10.0f+" fps";
	    } else
		return "";
	}
    }
    
    public static void main(String s[]) {
	int port=-1;
	if(s.length<2)
	    usage();
	if(s[1].toUpperCase().compareTo("RLE")==0)
	    port=VisionRleListener.defPort;
	else if(s[1].toUpperCase().compareTo("RAW")==0)
	    port=VisionRawListener.defPort;
	else if(s[1].toUpperCase().compareTo("PGSS")==0)
	    port=VisionPGSSListener.defPort;
	else {
	    System.err.println("PGSSVisionGUI: Unrecognized format: "+s[1]);
	    usage();
	}
	if(s.length>2)
	    port=Integer.parseInt(s[1]);
	String[] args=new String[1];
	args[0]=s[1];
	PGSSVisionGUI gui=new PGSSVisionGUI(s[0],port,args);
	gui.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) { System.exit(0); } });
	gui.show();
    }
    
    public static void usage() {
	System.out.println("Usage: java PGSSVisionGUI host (RLE|raw|PGSS) [port]");
	System.out.println("       if port is not specified, it defaults to:");
	System.out.println("       "+VisionRawListener.defPort+" for raw");
	System.out.println("       "+VisionRleListener.defPort+" for RLE.");
	System.out.println("       "+VisionPGSSListener.defPort+" for PGSS.");
	System.exit(2);
    }
    
    public void actionPerformed(ActionEvent e) {
	if(e.getActionCommand().compareTo("YUV")==0) {
	    VisionRaw v=(VisionRaw)vision;
	    if(v!=null)
		v.setConvertRGB(false);
	} else if(e.getActionCommand().compareTo("RGB")==0) {
	    VisionRaw v=(VisionRaw)vision;
	    if(v!=null)
		v.setConvertRGB(true);
	} else if(e.getActionCommand().compareTo("freeze")==0) {
	    isFreezeFrame=!isFreezeFrame;
	    if(!isFreezeFrame) {
		state="Reconnecting...";
		vision.open();
	    } else {
		state="Disconnecting...";
		vision.close();
		// BEGIN PGSS ADDITIONS
		vision.getListener().printRegionMap();
		// END PGSS ADDITIONS
	    }
	} else if(e.getActionCommand().compareTo("aspect")==0) {
	    vision.setLockAspectRatio(((JCheckBox)e.getSource()).isSelected());
	} else if(e.getActionCommand().compareTo("seq")==0) {
	    imgWrite=new ImageSequenceWriterThread(vision.getListener(), saveImageBut);
	    saveImageBut.setText("Stop Saving Sequence");
	    saveImageBut.setToolTipText("Click to stop buffering new frames - already captured frames will continue to be written (unless you close the window)");
	    saveImageBut.setActionCommand("stopseq");
	    Component cur=this;
	    while(cur.getParent()!=null) {
		cur=cur.getParent();
		System.out.println("PGSSVisionGUI Weird: "+cur);
	    }
	    FileDialog f=new FileDialog((Frame)cur,"Save Image Sequence",FileDialog.SAVE);
	    f.show();
	    if(f.getFile()==null || f.getFile().compareTo("")==0) {
		saveImageBut.doClick();
		return;
	    }
	    String base;
	    String format;
	    if(f.getFile().lastIndexOf('.')==-1) {
		format="png";
		base=f.getFile();
	    } else {
		int i=f.getFile().lastIndexOf(".");
		format=f.getFile().substring(i+1);
		base=f.getFile().substring(0,i);
	    }
	    int first=base.indexOf('#');
	    int last=base.lastIndexOf('#');
	    boolean appendTime=(first==-1);
	    imgWrite.setDirectory(f.getDirectory());
	    f.dispose();
	    if(first!=-1)
		imgWrite.setName(base.substring(0,first),last-first+1,base.substring(last+1),format);
	    else
		imgWrite.setName(base,0,"",format);
	    imgWrite.start();
	} else if(e.getActionCommand().compareTo("stopseq")==0) {
	    saveImageBut.setText("Save Image Sequence");
	    saveImageBut.setToolTipText("Saves to a series of files - use .jpg or .png extension to choose format; #'s will be replaced with index, otherwise timecode is appended");
	    saveImageBut.setActionCommand("seq");
	    imgWrite.interrupt();
	} else if(e.getActionCommand().compareTo("img")==0) {
	    Component cur=this;
	    while(cur.getParent()!=null) {
		cur=cur.getParent();
		System.out.println("PGSSVisionGUI Weird: "+cur);
	    }
	    FileDialog f=new FileDialog((Frame)cur,"Save Image",FileDialog.SAVE);
	    f.show();
	    if(f.getFile()!=null && f.getFile().compareTo("")!=0) {
		String format="png";
		int i=f.getFile().lastIndexOf(".");
		if(i!=-1)
		    format=f.getFile().substring(i+1);
		try {
		    ImageIO.write(vision.getListener().getImage(),format,new FileOutputStream(f.getDirectory()+f.getFile()));
		} catch(Exception ex) {}
	    }
	    f.dispose();
	} else if(e.getSource()==reconnectBut) {
	    vision.close();
	    vision.open();
	}
    }
    
    class CloseVisionAdapter extends WindowAdapter {
	PGSSVisionGUI gui;
	CloseVisionAdapter(PGSSVisionGUI gui) {this.gui=gui;}
	public void windowClosing(WindowEvent e) {
	    gui.vision.close();
	    if(gui.imgWrite!=null && gui.imgWrite.isAlive()) {
		if(!gui.imgWrite.isInterrupted() && !gui.imgWrite.stopping)
		    gui.imgWrite.interrupt();
		while(gui.imgWrite.isInterrupted())
		    try { Thread.sleep(50); } catch(Exception ex) {}
		if(!gui.imgWrite.stopping)
		    System.out.println("imgWrite refuses to stop");
		gui.imgWrite.interrupt(); //this second one should kill it
		while(gui.imgWrite.isAlive())
		    try { Thread.sleep(50); } catch(Exception ex) {}
	    }
	}
    }
    
    public void visionUpdated(VisionListener l) {
	if(l.isConnected()!=connected) {
	    connected=l.isConnected();
	    if(connected) {
		freezeBut.setEnabled(true);
		freezeBut.setText("Freeze Frame");
		freezeBut.setToolTipText("Freezes current frame (disconnects from stream)");
		isFreezeFrame=false;
		saveImageBut.setEnabled(true);
		saveImageBut.setText("Save Image Sequence");
		saveImageBut.setToolTipText("Saves to a series of files - use .jpg or .png extension to choose format; #'s will be replaced with index, otherwise timecode is appended");
		saveImageBut.setActionCommand("seq");
		state="Connected.";
	    } else {
		if(vision._image==null)
		    saveImageBut.setEnabled(false);
		else {
		    saveImageBut.setText("Save Image");
		    saveImageBut.setToolTipText("Save current image shown - use .jpg or .png extension to choose format");
		    saveImageBut.setActionCommand("img");
		}
		if(isFreezeFrame) {
		    state="Disconnected.";
		    freezeBut.setText("Unfreeze");
		    freezeBut.setToolTipText("Reconnects to stream");
		} else {
		    state="Reconnecting...";
		    freezeBut.setEnabled(false);
		}
	    }
	}
	if(connected) {
	    if(lastFrameTime==0) {
		if(l.getTimeStamp()!=null)
		    lastFrameTime=l.getTimeStamp().getTime();
	    } else {
		long cur=l.getTimeStamp().getTime();
		mspf=mspf*mspfGamma+(cur-lastFrameTime)*(1-mspfGamma);
		lastFrameTime=cur;
	    }
	} else {
	    lastFrameTime=0;
	}
    }
    
    public PGSSVisionGUI(String host, String[] args) {
	super();
	int port=-1;
	for(int i=0; i<args.length; i++) {
	    if(args[i].toUpperCase().compareTo("RLE")==0) {
		isRLE=true;
		isRaw=false;
		isPGSS=false;
	    } else if(args[i].toUpperCase().compareTo("RAW")==0) {
		isRaw=true;
		isRLE=false;
		isPGSS=false;
	    } else if(args[i].toUpperCase().compareTo("PGSS")==0) {
		isPGSS=true;
		isRaw=false;
		isRLE=false;
	    } else
		System.err.println("PGSSVisionGUI: Unrecognized argument: "+args[0]);
	}
	if(isRLE)
	    port=VisionRleListener.defPort;
	else if(isRaw)
	    port=VisionRawListener.defPort;
	else if(isPGSS)
	    port=VisionPGSSListener.defPort;
	init(host,port,args);
    }
    
    public PGSSVisionGUI(String host, String[] args, PGSSWalkGUI walkGUI) {
	super();
	int port=-1;
	for(int i=0; i<args.length; i++) {
	    if(args[i].toUpperCase().compareTo("RLE")==0) {
		isRLE=true;
		isRaw=false;
		isPGSS=false;
	    } else if(args[i].toUpperCase().compareTo("RAW")==0) {
		isRaw=true;
		isRLE=false;
		isPGSS=false;
	    } else if(args[i].toUpperCase().compareTo("PGSS")==0) {
		isPGSS=true;
		isRaw=false;
		isRLE=false;
	    } else
		System.err.println("PGSSVisionGUI: Unrecognized argument: "+args[0]);
	}
	if(isRLE)
	    port=VisionRleListener.defPort;
	else if(isRaw)
	    port=VisionRawListener.defPort;
	else if(isPGSS)
	    port=VisionPGSSListener.defPort;
	this.walkGUI=walkGUI;
	init(host,port,args);
    }
    
    public PGSSVisionGUI(String host, int port, String[] args) {
	super();
	init(host,port,args);
    }
    
    public PGSSVisionGUI(String host, int port,
			 String[] args, PGSSWalkGUI walkGUI) {
	super();
	this.walkGUI=walkGUI;
	init(host,port,args);
    }
    
    public void init(String host, int port, String[] args) {
	int strutsize=10;
	int sepsize=5;
	getContentPane().setLayout(new BorderLayout());
	getContentPane().add(Box.createVerticalStrut(strutsize),BorderLayout.NORTH);
	getContentPane().add(Box.createHorizontalStrut(strutsize),BorderLayout.WEST);
	getContentPane().add(Box.createHorizontalStrut(strutsize),BorderLayout.EAST);
	//always use RLE size for default - we'll assume it's full resolution
	vision=null;
	for(int i=0; i<args.length; i++) {
	    if(args[i].toUpperCase().compareTo("RLE")==0) {
		setTitle("TekkotsuMon: Vision RLE");
		vision=new VisionRle(new VisionRleListener(host,port));
		isRLE=true;
		isRaw=false;
		isPGSS=false;
	    } else if(args[i].toUpperCase().compareTo("RAW")==0) {
		setTitle("TekkotsuMon: Vision Raw");
		vision=new VisionRaw(new VisionRawListener(host,port));
		isRaw=true;
		isRLE=false;
		isPGSS=false;
	    } else if(args[i].toUpperCase().compareTo("PGSS")==0) {
		setTitle("TekkotsuMon: Vision PGSS");
		vision=new VisionPGSS(new VisionPGSSListener(host,port,walkGUI));
		isPGSS=true;
		isRaw=false;
		isRLE=false;
	    } else
		System.err.println("PGSSVisionGUI: Unrecognized argument: "+args[i]);
	}
	if(vision==null) {
	    System.err.println("PGSSVisionGUI: Error: Vision mode not specified");
	} else {
	    vision.setMinimumSize(new Dimension(VisionRleListener.width/2, VisionRleListener.height/2));
	    vision.setPreferredSize(new Dimension(VisionRleListener.width*2, VisionRleListener.height*2));
	    vision.setLockAspectRatio(true);
	    getContentPane().add(vision,BorderLayout.CENTER);
	}
	{
	    Box tmp2=Box.createHorizontalBox();
	    tmp2.add(Box.createHorizontalStrut(strutsize));
	    {
		Box tmp3=Box.createVerticalBox();
		if(isRaw) {
		    Box tmp4=Box.createHorizontalBox();
		    ButtonGroup group=new ButtonGroup();
		    JRadioButton tmpRad;
		    tmpRad=new JRadioButton("RGB");
		    tmpRad.setSelected(true);
		    tmpRad.addActionListener(this);
		    tmpRad.setToolTipText("Shows RGB colorspace");
		    group.add(tmpRad);
		    tmp4.add(tmpRad);
		    tmpRad=new JRadioButton("YUV");
		    tmpRad.addActionListener(this);
		    tmpRad.setToolTipText("Shows YUV colorspace");
		    group.add(tmpRad);
		    tmp4.add(tmpRad);
		    tmp3.add(tmp4);
		}
		aspectBut=new JCheckBox("Lock 11:9 aspect");
		aspectBut.setAlignmentX(0.5f);
		aspectBut.addActionListener(this);
		aspectBut.setActionCommand("aspect");
		aspectBut.setSelected(true);
		aspectBut.setToolTipText("Forces displayed image to hold transmitted image's aspect ratio");
		tmp3.add(aspectBut);
		freezeBut=new JButton("Freeze Frame");
		freezeBut.setAlignmentX(0.5f);
		freezeBut.addActionListener(this);
		freezeBut.setActionCommand("freeze");
		freezeBut.setEnabled(false);
		freezeBut.setToolTipText("Freezes current frame (disconnects from stream)");
		tmp3.add(freezeBut);
		saveImageBut=new JButton("Save Image Sequence");
		saveImageBut.setAlignmentX(0.5f);
		saveImageBut.addActionListener(this);
		saveImageBut.setActionCommand("seq");
		saveImageBut.setEnabled(false);
		saveImageBut.setToolTipText("Saves to a series of files - use .jpg or .png extension to choose format; #'s will be replaced with index, otherwise timecode is appended");
		tmp3.add(saveImageBut);
		tmp3.add(Box.createVerticalStrut(strutsize));
		tmp3.add(new JSeparator());
		tmp3.add(Box.createVerticalStrut(strutsize-sepsize));
		{
		    Box tmp4=Box.createHorizontalBox();
		    tmp4.add(status=new JLabel(state));
		    tmp4.add(Box.createHorizontalGlue());
		    reconnectBut=new JButton(carrows);
		    reconnectBut.setPreferredSize(new Dimension(carrows.getIconWidth(),carrows.getIconHeight()));
		    reconnectBut.addActionListener(this);
		    reconnectBut.setToolTipText("Drop current connection and try again.");
		    tmp4.add(reconnectBut);
		    tmp3.add(tmp4);
		}
		tmp3.add(Box.createVerticalStrut(strutsize));
		tmp2.add(tmp3);
	    }
	    tmp2.add(Box.createHorizontalStrut(strutsize));
	    getContentPane().add(tmp2,BorderLayout.SOUTH);
	}
	pack();
	addWindowListener(new CloseVisionAdapter(this));
	vision.getListener().addListener(this);
	(new StatusUpdateThread(this)).start();
    }

    // BEGIN PGSS METHODS

    void setUserPreferredVelocity(int userPreferredVelocity) {
	vision.getListener().setUserPreferredVelocity(userPreferredVelocity);
    }

    // END PGSS METHODS
}
