#include "get_time.h"

#ifndef PLATFORM_APERIOS
extern unsigned int simulator_time; //!< the current time the simulator wants it to be
unsigned int get_time() {
  return simulator_time;
}
#else
#include <MCOOP.h>
unsigned int get_time() {
  static struct SystemTime time;
  GetSystemTime(&time);
  return time.seconds*1000+time.useconds/1000;
}
#endif

/*! @file
 * @brief Implementation of get_time(), a simple way to get the current time since boot in milliseconds
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_1 $
 * $Revision: 1.3 $
 * $State: Rel $
 * $Date: 2003/07/25 20:18:07 $
 */
